# phpMyAdmin SQL Dump
# version 2.5.6
# http://www.phpmyadmin.net
#
# Host: localhost
# Generation Time: Nov 12, 2004 at 11:22 PM
# Server version: 4.0.20
# PHP Version: 4.3.8
# 
# 

# --------------------------------------------------------

#
# Table structure for table `addon_groups`
#

CREATE TABLE `addon_groups` (
  `addon_gid` int(11) unsigned NOT NULL auto_increment,
  `name` varchar(255) NOT NULL default '',
  `group_payment` text NOT NULL,
  `group_addons` text NOT NULL,
  `group_status` int(1) NOT NULL default '0',
  PRIMARY KEY  (`addon_gid`)
) TYPE=MyISAM COMMENT='Addon Group table.' AUTO_INCREMENT=1 ;

#
# Dumping data for table `addon_groups`
#


# --------------------------------------------------------

#
# Table structure for table `addon_specs`
#

CREATE TABLE `addon_specs` (
  `aid` bigint(22) unsigned NOT NULL auto_increment,
  `addon_pay_methods` text NOT NULL,
  `addon_name` varchar(255) NOT NULL default '',
  `addon_description` text NOT NULL,
  `addon_show_description` int(1) NOT NULL default '0',
  `setup_cost` float NOT NULL default '0',
  `setup_activate` int(1) NOT NULL default '0',
  `addon_cost` float NOT NULL default '0',
  `addon_state` varchar(255) NOT NULL default '',
  `addon_activate` int(1) NOT NULL default '0',
  `unique_ip` int(1) NOT NULL default '0',
  `extra_webspace` int(15) NOT NULL default '0',
  `private_ns` int(1) NOT NULL default '0',
  `coupon` int(1) NOT NULL default '0',
  `coupon_terms` int(1) NOT NULL default '0',
  `coupon_code` varchar(255) NOT NULL default '',
  `coupon_discount_type` int(1) NOT NULL default '0',
  `coupon_discount_percent` float NOT NULL default '0',
  `coupon_discount_whole` float NOT NULL default '0',
  `expires` int(40) NOT NULL default '0',
  PRIMARY KEY  (`aid`)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

#
# Dumping data for table `addon_specs`
#


# --------------------------------------------------------

#
# Table structure for table `affiliate_details`
#

CREATE TABLE `affiliate_details` (
  `afdid` bigint(22) unsigned NOT NULL auto_increment,
  `afuid` bigint(22) NOT NULL default '0',
  `oid` bigint(22) NOT NULL default '0',
  `refered_uid` bigint(22) NOT NULL default '0',
  `record_payout_type` int(11) NOT NULL default '0',
  `pid` int(22) NOT NULL default '0',
  `package_name` varchar(255) NOT NULL default '',
  `total_amount_package` decimal(10,2) NOT NULL default '0.00',
  `total_due_to_client` decimal(10,2) NOT NULL default '0.00',
  `ogcreate` int(40) default NULL,
  `last_updated` int(10) NOT NULL default '0',
  `status` int(1) NOT NULL default '0',
  PRIMARY KEY  (`afdid`)
) TYPE=MyISAM COMMENT='Affiliate details table' AUTO_INCREMENT=1 ;

#
# Dumping data for table `affiliate_details`
#


# --------------------------------------------------------

#
# Table structure for table `affiliate_history`
#

CREATE TABLE `affiliate_history` (
  `afhid` bigint(22) unsigned NOT NULL auto_increment,
  `afuid` bigint(22) NOT NULL default '0',
  `period_of` int(40) default NULL,
  `paid_date` int(10) NOT NULL default '0',
  `owed_to_client` decimal(10,2) NOT NULL default '0.00',
  `status` int(11) NOT NULL default '0',
  PRIMARY KEY  (`afhid`)
) TYPE=MyISAM COMMENT='History of monthly payments' AUTO_INCREMENT=1 ;

#
# Dumping data for table `affiliate_history`
#


# --------------------------------------------------------

#
# Table structure for table `affiliate_user`
#

CREATE TABLE `affiliate_user` (
  `afuid` bigint(22) unsigned NOT NULL auto_increment,
  `uid` bigint(22) NOT NULL default '0',
  `ssn_tax_id` varchar(11) NOT NULL default '',
  `payable_to` varchar(255) NOT NULL default '',
  `ogcreate` int(40) default NULL,
  `status` int(11) NOT NULL default '1',
  PRIMARY KEY  (`afuid`)
) TYPE=MyISAM COMMENT='Affiliate user table' AUTO_INCREMENT=1 ;

#
# Dumping data for table `affiliate_user`
#


# --------------------------------------------------------

#
# Table structure for table `authnet_batch`
#

CREATE TABLE `authnet_batch` (
  `bid` bigint(22) unsigned NOT NULL auto_increment,
  `txn_id` varchar(255) NOT NULL default '',
  `customer_ip_address` varchar(25) NOT NULL default '',
  `description` varchar(255) NOT NULL default '',
  `currency_code` varchar(10) NOT NULL default '',
  `transaction_type` varchar(25) NOT NULL default '',
  `recurring_billing` char(3) NOT NULL default 'YES',
  `payment_method` char(2) NOT NULL default 'CC',
  `ogcreate` varchar(40) NOT NULL default '',
  `response_reason_text` varchar(255) NOT NULL default '',
  `batch_status` int(1) NOT NULL default '0',
  `oid` bigint(22) NOT NULL default '0',
  `uid` bigint(22) NOT NULL default '0',
  `ccid` bigint(22) NOT NULL default '0',
  `invoice_number` varchar(255) NOT NULL default '',
  `master_batch` int(1) NOT NULL default '0',
  PRIMARY KEY  (`bid`)
) TYPE=MyISAM COMMENT='Authorize.net Batch Creation' AUTO_INCREMENT=1 ;

#
# Dumping data for table `authnet_batch`
#


# --------------------------------------------------------

#
# Table structure for table `authnet_master_cc`
#

CREATE TABLE `authnet_master_cc` (
  `ccid` bigint(22) unsigned NOT NULL auto_increment,
  `customer_first_name` varchar(255) NOT NULL default '',
  `customer_last_name` varchar(255) NOT NULL default '',
  `customer_address` varchar(255) NOT NULL default '',
  `customer_city` varchar(255) NOT NULL default '',
  `customer_state` varchar(255) NOT NULL default '',
  `customer_zip` varchar(255) NOT NULL default '',
  `customer_country` varchar(255) NOT NULL default '',
  `customer_phone` varchar(25) NOT NULL default '',
  `customer_fax` varchar(25) NOT NULL default '',
  `customer_email` varchar(255) NOT NULL default '',
  `card_info` text NOT NULL,
  `ogcreate` varchar(40) NOT NULL default '',
  `uid` bigint(22) NOT NULL default '0',
  `master_cc` int(1) NOT NULL default '0',
  PRIMARY KEY  (`ccid`)
) TYPE=MyISAM COMMENT='Authorize.net master cc data' AUTO_INCREMENT=1 ;

#
# Dumping data for table `authnet_master_cc`
#


# --------------------------------------------------------

#
# Table structure for table `autopilot_fraudcall`
#

CREATE TABLE `autopilot_fraudcall` (
  `fraudcall_key` varchar(255) NOT NULL default '',
  `fraudcall_value` text NOT NULL,
  `fraudcall_message` varchar(255) NOT NULL default '',
  `display_order` int(1) NOT NULL default '0',
  UNIQUE KEY `fraudcall_key` (`fraudcall_key`)
) TYPE=MyISAM;

#
# Dumping data for table `autopilot_fraudcall`
#

INSERT INTO `autopilot_fraudcall` VALUES ('activate_fraud_call', 'no', '', 0);
INSERT INTO `autopilot_fraudcall` VALUES ('install_121', 'no', 'Dialed unsuccessfully: Toll Free numbers cannot be dialed.', 0);
INSERT INTO `autopilot_fraudcall` VALUES ('install_122', 'stop', 'Dialed unsuccessfully: Phone number was in an undialable format.', 0);
INSERT INTO `autopilot_fraudcall` VALUES ('install_123', 'stop', 'Dialed unsuccessfully: Undialable country.', 0);
INSERT INTO `autopilot_fraudcall` VALUES ('install_124', 'no', 'Dialed unsuccessfully: Call cannot be dialed.', 0);
INSERT INTO `autopilot_fraudcall` VALUES ('install_125', 'no', 'Dialed unsuccessfully: Invalid phone number - phone number cannot begin with "1".', 0);
INSERT INTO `autopilot_fraudcall` VALUES ('install_126', 'no', 'Dialed unsuccessfully: Invalid phone number - area code and Country code combination<br>&nbsp;does not match proper format.', 0);
INSERT INTO `autopilot_fraudcall` VALUES ('install_130', 'no', 'Cannot call Cell Phone as per user\'s preferences.', 0);
INSERT INTO `autopilot_fraudcall` VALUES ('install_131', 'no', 'User does not have sufficient call credits for this call to be placed.', 0);
INSERT INTO `autopilot_fraudcall` VALUES ('install_140', 'no', 'PVS_USERNAME and PVS_PASSWORD is incorrect.', 0);
INSERT INTO `autopilot_fraudcall` VALUES ('install_150', 'no', 'API Post incomplete.', 0);
INSERT INTO `autopilot_fraudcall` VALUES ('install_320', 'stop', 'Caller DECLINED transaction.', 0);
INSERT INTO `autopilot_fraudcall` VALUES ('install_331', 'stop', 'Call failed: The line was busy when we called you.', 0);
INSERT INTO `autopilot_fraudcall` VALUES ('install_332', 'stop', 'Call failed: The call was answered, but nobody responded. Our system detects and waits<br>&nbsp;for a human to say "Hello" before the verification process beings.', 0);
INSERT INTO `autopilot_fraudcall` VALUES ('install_333', 'stop', 'Call failed: The call was answered, but there were more than 3 errors made<br>&nbsp;while entering approve or decline.', 0);
INSERT INTO `autopilot_fraudcall` VALUES ('install_334', 'stop', 'Call failed: An answering machine picked up.', 0);
INSERT INTO `autopilot_fraudcall` VALUES ('install_335', 'stop', 'Call failed: The phone number was unreachable, possibly out of service.', 0);
INSERT INTO `autopilot_fraudcall` VALUES ('install_336', 'stop', 'Call failed: Fax machine or modem answered call.', 0);
INSERT INTO `autopilot_fraudcall` VALUES ('install_337', 'stop', 'Call failed: No answer after 7 rings.', 0);
INSERT INTO `autopilot_fraudcall` VALUES ('install_338', 'no', 'Call failed: System error on VariLogix end.', 0);
INSERT INTO `autopilot_fraudcall` VALUES ('install_339', 'no', 'Call failed: Internal system error on VariLogix end.', 0);
INSERT INTO `autopilot_fraudcall` VALUES ('install_3310', 'no', 'Call failed: Cannot call international cell phone.', 0);
INSERT INTO `autopilot_fraudcall` VALUES ('pvs_id', '', '', 0);
INSERT INTO `autopilot_fraudcall` VALUES ('pvs_password', '', '', 0);
INSERT INTO `autopilot_fraudcall` VALUES ('fraud_low', 'yes', 'Call Processed Successfully: [ Very Low Fraud Risk ] 0.00 to 3.50', 3);
INSERT INTO `autopilot_fraudcall` VALUES ('fraud_mid', 'no', 'Call Processed Successfully: [ Medium Fraud Risk ] 3.51 - 7.00', 2);
INSERT INTO `autopilot_fraudcall` VALUES ('fraud_high', 'no', 'Call Processed Successfully: [ High Fraud Risk ] 7.01 - 10.00', 1);

# --------------------------------------------------------

CREATE TABLE `autopilot_fraudgate` (
  `fg_variable` varchar(32) NOT NULL default '',
  `fg_name` varchar(50) NOT NULL default '',
  `fg_type` varchar(128) NOT NULL default '',
  `fg_value` varchar(255) default NULL,
  `fg_description` text,
  `fg_function` varchar(255) NOT NULL default ''
) TYPE=MyISAM;

INSERT INTO `autopilot_fraudgate` VALUES ('activate', 'Activate Module?', 'FUNCTION', '0', 'Do you wish to activate your FraudGate module?', 'radioChoices("activate", array("Yes" => 1, "No" => 0),0,');
INSERT INTO `autopilot_fraudgate` VALUES ('FG_LOGIN', 'Username', 'input type="text" name="FG_LOGIN" size=20 maxlength=20', 'username', 'Your FraudGate account username.', '');
INSERT INTO `autopilot_fraudgate` VALUES ('FG_PASSWORD', 'Password', 'input type="password" name="FG_PASSWORD" size=20 maxlength=20', 'password', 'Your FraudGate account password.', '');
INSERT INTO `autopilot_fraudgate` VALUES ('stepCall', 'Pre-authorize Transactions?', 'FUNCTION', '0', 'Select ''Yes'' if you would like to perform the verification <i>before</i> the credit card is authorized.  Select ''No'' if you would like to perform the verification <i>after</i> the credit card is authorized.', 'radioChoices("stepCall", array("Yes" => 1, "No" => 0),1,');
INSERT INTO `autopilot_fraudgate` VALUES ('FG_MENU_ID', 'Menu ID', 'input type="text" name="FG_MENU_ID" size=4 maxlength=4', '11', 'The menu ID that should be used to place the phone call.', '');
INSERT INTO `autopilot_fraudgate` VALUES ('FG_MAX_RETRY', 'Max Retries', 'FUNCTION', '0', 'Enter how many times you wish to retry the call if it fails at first.', 'selectBoxes2(FG_MAX_RETRY, 5,');
INSERT INTO `autopilot_fraudgate` VALUES ('FG_TEST_REQUEST', 'Test Request?', 'FUNCTION', 'FALSE', 'Set this to ''True'' if you want to test the gateway and make sure the integration is functioning properly. FraudGate will only post back in the case of an error. Otherwise, it will return as a successful test and not be inserted into your call history. The call is not actually made.', 'radioChoices("FG_TEST_REQUEST", array("True" => "TRUE", "False" => "FALSE"),0,');
INSERT INTO `autopilot_fraudgate` VALUES ('FG_MATCHER', 'Matcher', 'FUNCTION', 'TRUE', 'Set this to ''True'' if you''d like a phone call placed regardless of the fraud score.', 'radioChoices("FG_MATCHER", array("True" => "TRUE", "False" => "FALSE"),0,');
INSERT INTO `autopilot_fraudgate` VALUES ('FG_POST_BACK_URL', 'Postback Method', 'input type="text" name="FG_POST_BACK_URL" size=40', 'http://yoursite.com/receiveCall.php', 'Be sure to change the url to the path to your installed directory and website. The HTTP method you would like the gateway to passback data in. POST is highly recommended.', '');
INSERT INTO `autopilot_fraudgate` VALUES ('FG_POST_BACK_METHOD', 'PostBack Method', 'FUNCTION', 'POST', 'The method your script uses. The default uses POST method.', 'radioChoices("FG_POST_BACK_METHOD", array("POST" => "POST", "GET" => "GET"),0,');
INSERT INTO `autopilot_fraudgate` VALUES ('FG_HOUR', 'Hour Offset', 'FUNCTION', '0', 'The number of hours the gateway should delay placing the call.', 'selectBoxes2(FG_HOUR, 24,');
INSERT INTO `autopilot_fraudgate` VALUES ('FG_MIN', 'Minute Offset', 'FUNCTION', '0', 'The number of minutes the gateway should delay placing the call.', 'selectBoxes2(FG_MIN, 59,');
INSERT INTO `autopilot_fraudgate` VALUES ('FG_INPUT_1', 'Input 1', 'FUNCTION', 'order number', 'The first input that you would like to collect from the caller.<br>Random numbers will be used for pre-authorization verifications. The order number should be used for post-authorizations.', 'selectBoxes(FG_INPUT_1,');
INSERT INTO `autopilot_fraudgate` VALUES ('FG_INPUT_2', 'Input 2', 'FUNCTION', 'no input required', 'The second input that you would like to collect from the caller.<br>Random numbers will be used for pre-authorization verifications. The order number should be used for post-authorizations.', 'selectBoxes(FG_INPUT_2,');
INSERT INTO `autopilot_fraudgate` VALUES ('FG_INPUT_3', 'Input 3', 'FUNCTION', 'no input required', 'The third input that you would like to collect from the caller.<br>Random numbers will be used for pre-authorization verifications. The order number should be used for post-authorizations.', 'selectBoxes(FG_INPUT_3,');
INSERT INTO `autopilot_fraudgate` VALUES ('FG_INPUT_4', 'Input 4', 'FUNCTION', 'no input required', 'The fourth input that you would like to collect from the caller.<br>Random numbers will be used for pre-authorization verifications. The order number should be used for post-authorizations.', 'selectBoxes(FG_INPUT_4,');
INSERT INTO `autopilot_fraudgate` VALUES ('FG_INPUT_5', 'Input 5', 'FUNCTION', 'no input required', 'The fifth input that you would like to collect from the caller.<br>Random numbers will be used for pre-authorization verifications. The order number should be used for post-authorizations.', 'selectBoxes(FG_INPUT_5,');
INSERT INTO `autopilot_fraudgate` VALUES ('FG_INPUT_6', 'Input 6', 'FUNCTION', 'no input required', 'The sixth input that you would like to collect from the caller.<br>Random numbers will be used for pre-authorization verifications. The order number should be used for post-authorizations.', 'selectBoxes(FG_INPUT_6,');
INSERT INTO `autopilot_fraudgate` VALUES ('FG_INPUT_7', 'Input 7', 'FUNCTION', 'no input required', 'The seventh input that you would like to collect from the caller.<br>Random numbers will be used for pre-authorization verifications. The order number should be used for post-authorizations.', 'selectBoxes(FG_INPUT_7,');
INSERT INTO `autopilot_fraudgate` VALUES ('FG_INPUT_8', 'Input 8', 'FUNCTION', 'no input required', 'The eighth input that you would like to collect from the caller.<br>Random numbers will be used for pre-authorization verifications. The order number should be used for post-authorizations.', 'selectBoxes(FG_INPUT_8,');
INSERT INTO `autopilot_fraudgate` VALUES ('FG_INPUT_9', 'Input 9', 'FUNCTION', 'no input required', 'The ninth input that you would like to collect from the caller.<br>Random numbers will be used for pre-authorization verifications. The order number should be used for post-authorizations.', 'selectBoxes(FG_INPUT_9,');
INSERT INTO `autopilot_fraudgate` VALUES ('FG_INPUT_10', 'Input 10', 'FUNCTION', 'no input required', 'The tenth input that you would like to collect from the caller.<br>Random numbers will be used for pre-authorization verifications. The order number should be used for post-authorizations.', 'selectBoxes(FG_INPUT_10,');
INSERT INTO `autopilot_fraudgate` VALUES ('s_status', 'Successfully verified transactions set to:', 'FUNCTION', '0', 'NOTE: Only for post authorization orders.\r\n<br>\r\nSet the status that the account should be set to if FraudGate successfully verifies the order.', 'selectBoxes3(s_status,');
INSERT INTO `autopilot_fraudgate` VALUES ('f_status', 'Failed transactions set to:', 'FUNCTION', '2', 'NOTE: Only for post authorization orders.\r\n<br>\r\nSet the status that the account should be set to if FraudGate fails to verify the transaction.', 'selectBoxes3(f_status,');

#
# Table structure for table `autopilot_ip`
#

CREATE TABLE `autopilot_ip` (
  `ipid` bigint(22) unsigned NOT NULL auto_increment,
  `ip` varchar(40) NOT NULL default '',
  `created` int(20) NOT NULL default '0',
  PRIMARY KEY  (`ipid`)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

#
# Dumping data for table `autopilot_ip`
#


# --------------------------------------------------------

#
# Table structure for table `config`
#

CREATE TABLE `config` (
  `license` text NOT NULL,
  `site_title` varchar(255) NOT NULL default '',
  `site_name` varchar(255) NOT NULL default '',
  `balance_required_for_payment` int(6) NOT NULL default '0',
  `currency` varchar(5) NOT NULL default '',
  `currency_type` varchar(4) NOT NULL default '',
  `domain_fee` int(1) NOT NULL default '0',
  `resolve_server` varchar(255) NOT NULL default '',
  `run_domain_expire` char(3) NOT NULL default '',
  `do_registrations` char(3) NOT NULL default 'yes',
  `http_web` varchar(255) NOT NULL default '',
  `server_root` varchar(255) NOT NULL default '',
  `below_public` varchar(255) NOT NULL default '',
  `default_reseller_cpanel_theme` varchar(255) NOT NULL default '',
  `theme` varchar(255) NOT NULL default '',
  `strong_security` char(2) NOT NULL default '',
  `phpbb_active` char(2) NOT NULL default '',
  `input_style` varchar(255) NOT NULL default '',
  `button_style` varchar(255) NOT NULL default '',
  `copyright` varchar(255) NOT NULL default '',
  `get_mib_news` varchar(255) NOT NULL default '',
  `email_support` varchar(255) NOT NULL default '',
  `activate_support` char(3) NOT NULL default 'yes',
  `activate_serverstats` char(3) NOT NULL default 'yes',
  `email_admin` varchar(255) NOT NULL default '',
  `http_web_tools` varchar(255) NOT NULL default '',
  `http_admin` varchar(255) NOT NULL default '',
  `http_admin_tools` varchar(255) NOT NULL default '',
  `http_images` varchar(255) NOT NULL default '',
  `server_backup` varchar(255) NOT NULL default '',
  `resolver_log` varchar(255) NOT NULL default '',
  `server_tools` varchar(255) NOT NULL default '',
  `server_admin_inc` varchar(255) NOT NULL default '',
  `server_inc` varchar(255) NOT NULL default '',
  `server_admin` varchar(255) NOT NULL default '',
  `server_admin_tools` varchar(255) NOT NULL default '',
  `local_lang` varchar(255) NOT NULL default 'english',
  `invoice_notice_period` int(11) NOT NULL default '0',
  `tos_agreement` varchar(255) NOT NULL default '',
  `session_expire` int(3) NOT NULL default '36',
  `cont_resolve` int(1) NOT NULL default '0',
  `resolve_works` int(1) NOT NULL default '0',
  `use_enom` int(1) NOT NULL default '0',
  `enom_user` varchar(255) NOT NULL default '',
  `enom_pass` varchar(255) NOT NULL default '',
  `enom_ip` varchar(22) NOT NULL default '',
  `send_reminders` int(1) NOT NULL default '1',
  `enable_debugging` tinyint(1) NOT NULL default '1',
  `charset` varchar(25) NOT NULL default 'en-iso-8859-1',
  `ip_restrict` char(3) NOT NULL default 'no',
  `allow_proxy` char(3) NOT NULL default 'no',
  `maintenance` char(3) NOT NULL default 'no',
  `backup_to_disk` INT( 1 ) DEFAULT '1' NOT NULL ,
  `backup_to_mail` INT( 1 ) DEFAULT '1' NOT NULL ,
  `backup_frequency` INT( 3 ) DEFAULT '1' NOT NULL ,
  `backup_inc` INT( 3 ) DEFAULT '0' NOT NULL,
  PRIMARY KEY  (`site_title`),
  KEY `site_name` (`site_name`),
  KEY `currency` (`currency`),
  KEY `currency_type` (`currency_type`),
  KEY `domain_fee` (`domain_fee`),
  KEY `resolve_server` (`resolve_server`),
  KEY `run_domain_expire` (`run_domain_expire`),
  KEY `http_web` (`http_web`),
  KEY `server_root` (`server_root`),
  KEY `server_deploy` (`below_public`),
  KEY `default_reseller_cpanel_theme` (`default_reseller_cpanel_theme`),
  KEY `theme` (`theme`),
  KEY `strong_security` (`strong_security`),
  KEY `phpbb_active` (`phpbb_active`),
  KEY `input_style` (`input_style`),
  KEY `button_style` (`button_style`),
  KEY `copyright` (`copyright`),
  KEY `get_mib_news` (`get_mib_news`),
  KEY `email_support` (`email_support`),
  KEY `http_web_tools` (`http_web_tools`),
  KEY `http_admin` (`http_admin`),
  KEY `http_admin_tools` (`http_admin_tools`),
  KEY `http_images` (`http_images`),
  KEY `server_backup` (`server_backup`),
  KEY `resolver_log` (`resolver_log`),
  KEY `server_tools` (`server_tools`),
  KEY `server_admin_inc` (`server_admin_inc`),
  KEY `server_inc` (`server_inc`),
  KEY `server_admin` (`server_admin`),
  KEY `server_admin_tools` (`server_admin_tools`),
  KEY `local_lang` (`local_lang`),
  KEY `balance_required_for_payment` (`balance_required_for_payment`)
) TYPE=MyISAM COMMENT='Config Table';

#
# Dumping data for table `config`
#

INSERT INTO `config` VALUES ('', '', '', 0, '', '', 0, '', '', 'yes', '', '', '', '', '', '', '', '', '', '', '', '', 'yes', 'yes', '', '', '', '', '', '', '', '', '', '', '', '', 'english', 0, '', 36, 0, 0, 0, '', '', '', 1, 1, 'en-iso-8859-1', 'no', 'no', 'no', 1, 1, 1, 0);

# --------------------------------------------------------

#
# Table structure for table `domains`
#

CREATE TABLE `domains` (
  `dom_id` bigint(22) unsigned NOT NULL auto_increment,
  `oid` bigint(22) NOT NULL default '0',
  `uid` bigint(22) NOT NULL default '0',
  `tld_cost` float NOT NULL default '0',
  `domain_name` varchar(255) NOT NULL default '',
  `purchase_rc` varchar(25) NOT NULL default '',
  `purchase_text` varchar(255) NOT NULL default '',
  `modifyns_rc` varchar(25) NOT NULL default '',
  `modifyns_text` varchar(255) NOT NULL default '',
  `created` int(15) NOT NULL default '0',
  `expires` int(15) NOT NULL default '0',
  `order_id` varchar(255) NOT NULL default '',
  `password` text NOT NULL,
  `status` int(1) NOT NULL default '0',
  PRIMARY KEY  (`dom_id`)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

#
# Dumping data for table `domains`
#


# --------------------------------------------------------

#
# Table structure for table `email_templates`
#

CREATE TABLE `email_templates` (
  `emid` int(11) unsigned NOT NULL auto_increment,
  `name` varchar(255) NOT NULL default '',
  `subject` varchar(255) NOT NULL default '',
  `message` text NOT NULL,
  `attr_avail` text NOT NULL,
  `default_email` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`emid`)
) TYPE=MyISAM COMMENT='DO NOT EDIT DIRECTLY OR YOUR SYSTEM WILL BREAK IF YOU DO.' AUTO_INCREMENT=50 ;

#
# Dumping data for table `email_templates`
#

INSERT INTO `email_templates` VALUES (1, 'Domain Unresolved - 48hrs', '[1] {{domain_name}} not yet resolved, Action Required', '{{first_name}},\r\n{{domain_name}} that was installed on {{installed_date}} has not yet resolved to our servers.\r\n\r\nPlease check and make sure your domain name is pointed to the following nameservers:\r\n\r\nPrimary: \r\n{{ns1}}\r\n{{ns1_ip}}\r\n\r\nSecondary:\r\n{{ns2}}\r\n{{ns2_ip}}\r\n\r\nWe run checks on {{domain_name}} every 8 hours to see when and if it is pointing properly to our servers.\r\n\r\nIf your domain has not resolved in the next 48 hours, you may receive another email identical to this one.\r\n\r\nThis message was generated on: {{generate_date}}', '{{first_name}}|{{domain_name}}|{{ns1}}|{{ns1_ip}}|{{ns2}}|{{ns2_ip}}|{{generate_date}}|{{installed_date}}|', '');
INSERT INTO `email_templates` VALUES (2, 'Successfully Resolved', '[2] Your Domain, {{domain_name}} has Resolved to our Server', 'Hello {{first_name}},\r\n\r\nYour website, {{domain_name}}  is up and running!\r\n\r\nWe recommend saving and printing this email for your records.\r\n\r\nIf you cannot see your website yet, you may need to wait another 24 hours \r\nfor it to resolve (show up) on your ISP\\\'s servers. You should see a coming\r\nsoon page until you replace the index.html page on the site.\r\n\r\nYou can set up your email using Outlook Express or any other mail client\r\nusing these settings:\r\n\r\nPOP Server: mail.{{domain_name}} \r\nSMTP Server: mail.{{domain_name}} or the SMTP server of your ISP.\r\n(we recommend using the SMTP of your ISP for trouble free sending)\r\n\r\n\r\n===============================================\r\n\r\nAs the site administrator, you have the privilege to publish the site\r\nhomepage and manage email accounts. You may also use our Member Zone\r\ncontrol panel to access other features with your website:\r\n\r\nAdd / Modify / Delete Email Accounts\r\nManage & Create MySQL Databases\r\nView Your Bandwidth\r\nand so much more.....\r\n\r\nControl Panel can be accessed at:\r\n\r\nhttp://{{domain_name}}:2082 \r\nor\r\nhttp://{{domain_name}}/cpanel\r\n\r\nYour Username is: {{username}}\r\nYour Password is: {{password}}\r\n\r\nI.    Uploading Your Web Files\r\n-----------------------------------------------------------------\r\n\r\nYour homepage must be created and ready before you can upload your\r\nfiles. To name your web files, only lower case characters from a-z,\r\nnumbers from 0-9, and the underscore (_). Do not place spaces in\r\nyour file names and/or directories.\r\n\r\nYour initial page must be named \\\'index.html\\\'. Ensure that this first\r\npage of your web site is named correctly or else your web site will\r\nnot appear. Any other page linked to the \\\'index\\\' page can be named\r\nby you freely.\r\n\r\nOur web servers are configured so that your homepage can be viewed\r\nwith or without \\\'www\\\' at http://www.{{domain_name}}/ OR \r\nhttp://{{domain_name}}/.\r\n\r\nThis hosting package does not include FrontPage server extensions. If\r\nyour web contains any webbot components that require the server \r\nextensions you may encounter a publishing error. \r\n\r\nFTP (File Transfer Protocol)\r\n-----------------------------------------------------------------\r\n\r\nThe FTP (File Transfer Protocol) file transfer system is versatile\r\nas well as extremely useful. You can rename your files, upload,\r\ndownload, and manage most aspects of your account via FTP. If you are\r\nusing a Web authoring software package that handles the uploading of\r\nfiles to the server, such as Navigator Gold, then the correct\r\nconfiguration may be somewhat different. The following instructions\r\nassume that you are dialed up to your Internet Service Provider as\r\nyou normally are when browsing the web.\r\n\r\nTo upload your HTML documents follow these steps: \r\n\r\n1. Acquiring FTP Software \r\n\r\nWe recommend the use of WS-FTP LE 32 Bit which can be acquired at\r\nwww.ipswitch.com or www.tucows.com.\r\n\r\n2. Connecting and logging in via FTP \r\n\r\nDifferent graphical FTP programs will vary somewhat in their\r\ninterfaces and menu layouts, but are generally similar enough that\r\nthe following instructions will apply. Every FTP client will have a\r\nplace (a dialog box which automatically appears, or a menu selection\r\nwhich brings up such a box) where you enter information regarding\r\nwhich server on the Internet you want to hook up to. You may have to\r\nhit a button labeled \\\'Connect\\\' in order to get this box to come up.\r\nWhen you have found this box in your particular client, there are\r\nthree crucial pieces of information needed to log you in to your\r\naccount as the account owner. They are:\r\n\r\nHost Name = {{domain_name}}  \r\nUsername = {{username}} \r\nPassword = {{password}}\r\n\r\nOther settings to watch out for\r\n\r\n\\\'Anonymous Login\\\' checkbox - Some FTP programs have a checkbox\r\nlabeled \\\'Anonymous Login\\\', or something similar. You want to be sure\r\nthat this box is unchecked. Having this box inadvertently checked\r\nwill cause your client to log in as an anonymous user instead of the\r\naccount owner, even if you have entered your userid and password in\r\nthe appropriate places.\r\n\r\nInitial Directories - Sometimes having values in boxes which specify\r\nInitial Directories can cause your connection attempt to fail. It is\r\nbest to leave these boxes blank, or delete any default values which\r\nyou may find there.\r\n\r\nWhen uploading, please make sure your initial directory is public_html.\r\n\r\nHost Type - Generally \\\'Auto-detect\\\' is a safe value to have as the\r\nHost Type, but if it doesn\\\'t work use UNIX.\r\n\r\nWith these settings in place, click the Ok or Connect button to\r\nconnect to your web server. \r\n\r\n3. Root www level \r\n\r\nOnce you are logged in to the FTP server you be placed at the root\r\nor www level indicated by \\\'/\\\' in the remote site location box. The\r\nlocal system is your computer and the remote site is the web server.\r\n\r\n4. Moving files back and forth \r\n\r\nThe next step is to locate your files on your computer in the left\r\nset of list boxes. Select the files you wish to upload in the local\r\nmachine list boxes on the left portion of your screen. Next, click\r\nthe Copy, Transfer or arrow button to upload your files. \r\n\r\nThe procedure for retrieving files from your account is the same as\r\ndownloading, you just select the source and destinations in different\r\nlist boxes. \r\n\r\nIf you edit/make changes to a page, upload it to the remote server\r\nand overwrite the old file so that the updated page will appear on\r\nthe web. If changes cannot be seen after you have uploaded new \r\ncontent to your website, please try clearing your browser cache.\r\n\r\n===============================================\r\n\r\nosCommerce information (if applicable)\r\n\r\nIf you signed up for a TEP Special package, your script is located\r\nhere:\r\n\r\nCatalog:\r\nhttp://{{domain_name}}/default.php\r\n\r\nAdmin Section:\r\nhttp://{{domain_name}}/admin/index.php\r\n\r\nThis section has not been password protected.  You are able to\r\ndo this thru the control panel using WebProtect.\r\n\r\n===============================================\r\n\r\nOther Important Information:\r\n\r\nthe path to perl is #!/usr/bin/perl\r\nThere may be some instances where the following path\r\nwill work:\r\n#!/usr/local/bin/perl\r\n\r\n\\"/home/{{username}}/public_html\\" \r\nIs the absolute path for any cgi or php you setup. \r\n\r\n\r\nSendmail path is /usr/sbin/sendmail \r\n===============================================\r\n\r\nIf you have any questions, feel free to send them in.\r\n\r\nThank You.\r\n\r\nWeb Support Team\r\n\r\nThis message was generated on: {{generate_date}}', '{{domain_name}}|{{username}}|{{password}}|{{first_name}}|{{generate_date}}|', '');
INSERT INTO `email_templates` VALUES (3, 'Domain Stopped Resolving', '[3] {{domain_name}} has stopped responding to your servers', 'Hello,\r\n\r\nThe domain, {{domain_name}}, stopped resolving to the server {{server}}.\r\n\r\nYou may want to contact the owner to see if one of the \r\nfollowing has occurred:\r\n\r\n1) cancelled service and failed to notify\r\n2) domain has expired and they did not renew\r\n3) worst case, the server is down\r\n\r\nThis email will not repeat.  You will only be notified\r\nagain if the domain starts to resolve back to the server.\r\n\r\nThank you.\r\n\r\nYour AutoPilot\r\n\r\nThis message was generated on: {{generate_date}}', '{{domain_name}}|{{server}}|{{generate_date}}|', '');
INSERT INTO `email_templates` VALUES (4, 'Domain Resolve Report', '[4] Domain Resolve Report: {{generate_date}}', 'Here are the results of the last resolve run performed from your website database.\r\n\r\nTotal Resolved Domains: {{number_resolved}}\r\n\r\nList of Resolved and Emailed Domains:\r\n{{successful_domain_list}}\r\n\r\n-----------------------------\r\n\r\nTotal Unresolved Domains: {{number_unresolved}}\r\n\r\nUnresolved Domain List:\r\n{{unsuccessful_domain_list}}\r\n\r\n-----------------------------\r\n\r\nTotal Stopped Resolving Domains: {{stopped_responding}}\r\n\r\nStopped Responding Domain List:\r\n{{stopped_responding_list}}\r\n\r\n-----------------------------\r\n\r\nTotal Domains That Expire In 30 Days: {{x30_day_ct}}\r\n\r\n30 Day Expire List:\r\n{{x30_day_list}}\r\n\r\n-----------------------------\r\n\r\nTotal Domains That Expire In 5 Days: {{x5_day_ct}}\r\n\r\n5 Day Expire List:\r\n{{x5_day_list}}\r\n\r\n-----------------------------\r\n\r\nTotal Exipired Domain This Run: {{expired_ct}}\r\n\r\nExpired Domain List:\r\n{{expired_list}}\r\n\r\n-----------------------------\r\n\r\nThank you,\r\n\r\nYour AutoPilot\r\n\r\nThis message was generated on: {{generate_date}}', '{{generate_date}}|{{number_resolved}}|{{successful_domain_list}}|{{number_unresolved}}|{{unsuccessful_domain_list}}|{{stopped_responding}}|{{stopped_responding_list}}|{{x30_day_ct}}|{{x30_day_list}}|{{x5_day_ct}}|{{x5_day_list}}|{{expired_ct}}|{{expired_list}}|', '');
INSERT INTO `email_templates` VALUES (5, 'Server: Add new server', '[5] A new server was added [ {{server_name}} ]', 'Hello,\r\n\r\nThis is just to confirm that a new server has been added to the system.\r\n\r\nDetails:\r\n\r\nName: {{server_name}}\r\nIP: {{server_ip}}\r\nPrimary NS: {{primary_ns}}\r\nPrimary NS IP: {{primary_ns_ip}}\r\nSecondard NS: {{secondary_ns}}\r\nSecondard NS IP: {{secondary_ns_ip}}\r\nMaximum Accounts: {{max_accounts}}\r\n\r\nKeep this for your records.\r\n\r\nThank You.\r\n\r\nYour AutoPilot\r\n\r\nThis message was generated on: {{generate_date}}', '{{server_name}}|{{server_ip}}|{{primary_ns}}|{{primary_ns_ip}}|{{secondary_ns}}|{{secondary_ns_ip}}|{{max_accounts}}|{{generate_date}}|', '');
INSERT INTO `email_templates` VALUES (6, 'Max. Clients/Server Reached', '[6] Maximum Clients Reached on {{previous_active_server_name}}', 'Hello,\r\n\r\nYou have reached {{max_clients}} clients on {{previous_active_server_name}}. The server is full.\r\n\r\nThe AutoPilot successfully switched {{new_active_server_name}} to the {{server_role}} server.\r\n\r\nYou will need to login to the system and define the next active server.\r\n\r\nThank You.\r\n\r\nYour AutoPilot\r\n\r\nThis message was generated on: {{generate_date}}', '{{max_clients}}|{{previous_active_server_name}}|{{new_active_server_name}}|{{server_role}}|{{generate_date}}|', '');
INSERT INTO `email_templates` VALUES (7, 'New Client Installed', '[7] {{domain_name}} {{active_server_name}} [ {{generate_date}} ]', 'Hello,\r\n\r\nOn {{order_date}}, a new client {{active_server_name}}\r\n\r\nHere are the details:\r\n\r\nClient: {{first_name}} {{last_name}}\r\nEmail: {{email_address}}\r\nHow did you find us: {{how_found}}\r\nDomain: {{domain_name}}\r\nPackage Ordered: {{hosting_package}}\r\n{{addons}}{{pns1}}\r\n{{pns2}}\r\nPayment Type: {{payment_gateway}}\r\n{{coupon}}\r\nTotal Due Today: {{total_due_today}}\r\n\r\nThis order will rebill at a rate of {{total_reoccur}} {{payment_term}}\r\n\r\n{{client_notes}}\r\n\r\nThank you.\r\n\r\nYour AutoPilot\r\n\r\nThis message was generated on: {{generate_date}}', '{{order_date}}|{{active_server_name}}|{{first_name}}|{{last_name}}|{{domain_name}}|{{hosting_package}}|{{addons}}|{{payment_gateway}}|{{total_due_today}}||{{generate_date}}|{{total_reoccur}}|{{payment_term}}|{{email_address}}|{{how_found}}|{{coupon}}|{{pns1}}|{{pns2}}|{{client_notes}}|', '');
INSERT INTO `email_templates` VALUES (8, 'Order Received', '[8] Your Hosting ORDER has been received for {{domain_name}}', 'Hello,\r\n\r\nWe have received your hosting ORDER and will be processing it shortly.\r\n\r\nThe details of this ORDER are below:\r\n\r\nFirst Name: {{first_name}} {{last_name}}\r\nEmail: {{email_address}}\r\nHow did you find us: {{how_found}}\r\nDomain Name: {{domain_name}}\r\nPackage Ordered: {{hosting_package}}\r\n{{addons}}{{pns1}}\r\n{{pns2}}\r\nPayment Gateway: {{payment_gateway}}\r\n{{coupon}}\r\nTotal Due Today: {{total_due_today}}\r\n\r\nThis ORDER will rebill at a rate of {{total_reoccur}} {{payment_term}}\r\n\r\nYou should receive an email FROM us within the next 24 hours with more information. \r\n\r\n{{client_notes}}\r\n\r\nThank You.\r\n\r\nWeb Host Support\r\n\r\nThis message was generated on: {{generate_date}}', '{{first_name}}|{{last_name}}|{{domain_name}}|{{hosting_package}}|{{addons}}|{{payment_gateway}}|{{total_due_today}}|{{total_reoccur}}|{{payment_term}}|{{generate_date}}|{{email_address}}|{{how_found}}|{{coupon}}|{{pns1}}|{{pns2}}|{{client_notes}}| ', '');
INSERT INTO `email_templates` VALUES (9, 'Hosting Order Active: DNS email', '[9] Your Hosting Order for {{domain_name}} is Active', 'Hello,\r\n\r\nYour domain, {{domain_name}} has been installed and is ready for you to take some steps to finalize this process.\r\n\r\nPlease make sure the domain nameservers for this domain are set to:\r\n\r\n{{primary_ns}}\r\nresolves to {{primary_ns_ip}}\r\n\r\n{{secondary_ns}}\r\nresolves to {{secondary_ns_ip}}\r\n\r\nSome registrars do not require the use of the nameserver IPs, they are only provided if they are needed.\r\n\r\nWe monitor your domain for resolvement, automatically, every 8 hours.  As soon as your domain is resolving to our server, you will receive your welcome email with the needed information so you can get started.\r\n\r\nDon\\\'t hestiate to contact us if you have any questions.\r\n\r\nThank You.\r\n\r\nWeb Host Support\r\n\r\nThis message was generated on: {{generate_date}}', '{{domain_name}}|{{primary_ns}}|{{primary_ns_ip}}|{{secondary_ns}}|{{secondary_ns_ip}}|{{generate_date}}|', '');
INSERT INTO `email_templates` VALUES (10, 'Hosting Account Installed - Client Email', '[10] {{domain_name}} has been installed on our servers', 'Your new site, on our servers, is now fully operational and awaits publication of your code!\r\n \r\n------------------------------------------------------\r\nYOUR NEW HOSTING ACCOUNT INFORMATION\r\n------------------------------------------------------\r\n\r\nDomain: {{domain_name}}\r\n\r\nTemporary Web Path: http://{{ip}}/~{{whm_username}}/ \r\n(until your domain name resolves, use this link to access your site)\r\n\r\nIP: {{ip}}\r\n\r\nUsername: {{whm_username}}\r\n\r\nPassword: {{whm_password}} (please note password is CaSe SeNsItIvE)\r\n\r\nSMTP/POP3 mail server: mail.{{domain_name}}\r\n* email will not work until your domain resolved to our servers.\r\n\r\n------------------------------------------------------\r\n               IMPORTANT INFORMATION\r\n------------------------------------------------------\r\n\r\nClient Area Login:\r\n\r\nUsername: {{clientarea_username}}\r\nPassword: {{clientarea_password}}\r\nLogin Area: {{clientarea_loginlink}} \r\n\r\nCPanel Login:\r\nUsing CPanel, you can completely administer your new web hosting account! Login and check it out.\r\n\r\nhttp://{{ip}}/cpanel\r\n\r\nUsername: {{whm_username}}\r\nPassword: {{whm_password}} (please note password is CaSe SeNsItIvE)\r\n\r\nIf this account will use a transferred domain name, please update the DNS at your registrar to use the following servers:\r\n\r\n{{primary_ns}} {{primary_ns_ip}}\r\n{{secondary_ns}} {{secondary_ns_ip}}\r\n\r\nThank you for your order!\r\n\r\nWeb Support Team\r\n\r\nThis message was generated on: {{generate_date}}', '{{ip}}|{{whm_username}}|{{whm_password}}|{{domain_name}}|{{primary_ns}}|{{primary_ns_ip}}|{{secondary_ns}}|{{secondary_ns_ip}}|{{generate_date}}|{{clientarea_username}}|{{clientarea_password}}|{{clientarea_loginlink}}|{{installed_on_server}}|{{server_location}}', '');
INSERT INTO `email_templates` VALUES (24, 'Cancel Account: Request Cancel', '[24] {{domain_name}} Requests Cancellation', 'Hello,\r\n\r\nDomain, {{domain_name}} has requested to cancel their hosting\r\naccount and billing record.\r\n\r\nReason for cancellation:\r\n{{reason_for_cancel}}\r\n\r\nPlease login to the admin section to process this cancellation.\r\n\r\nThank you.\r\n\r\nYour AutoPilot\r\n\r\nThis message was generated on: {{generate_date}}', '{{domain_name}}|{{generate_date}}|{{reason_for_cancel}}|\r\n', '');
INSERT INTO `email_templates` VALUES (12, 'Affiliate Status Request', '[12] Client requests affiliate status', 'Hello,\r\n\r\nOn {{generate_date}}, {{client_name}} has requested an affiliate ID\r\nto start referring clients to your website.\r\n\r\nPlease login to your admin section and choose \\\'User Approval\\\' from\r\nthe affiliate menu and approve or deny this request.\r\n\r\nThank you.\r\n\r\nYour AutoPilot', '{{generate_date}}|{{client_name}}|', '');
INSERT INTO `email_templates` VALUES (13, 'Affiliate Status Approval', '[13] Affiliate Status Approved', 'Hello,\r\n\r\nOn {{generate_date}}, your request for affiliate status was approved\r\nby the site administrator.\r\n\r\nPlease visit {{login_path}} and login to your client\r\narea to view your affiliate area.\r\n\r\nFrom within the affiliate center, you can view all plans that have \r\naffiliate commissions, generate automatic links to refer and, view\r\nyour referral history.\r\n\r\nIf you have any questions, don\\\'t hestiate to contact the system admin.\r\n\r\nThank you.\r\n\r\nWeb Site Support', '{{generate_date}}|{{login_path}}|{{client_name}}|', '');
INSERT INTO `email_templates` VALUES (14, 'Affiliate Status Denied', '[14] Affiliate Request Denied', 'Hello,\r\n\r\nOn {{generate_date}}, your request for affiliate status was denied\r\nby the site administrator.\r\n\r\nPlease allow at least {{minimum_period_to_reapply}} days to go by before\r\nrequesting affiliate status again.\r\n\r\nIf you have any questions regarding this decision, please contact the\r\nsite admin.\r\n\r\nThank You.\r\n\r\nWeb Site Support', '{{generate_date}}|{{minimum_period_to_reapply}}|', '');
INSERT INTO `email_templates` VALUES (21, 'Domain Expire: 5 Day Notice', '[21] Your domain expires in 5 days or less', 'Hello,\r\n\r\nYour domain, {{domain_name}} is set to expire on {{expire_date}}.\r\n\r\nThis is a friendly reminder that if your domain expires, your\r\nwebsite and email will fail to work.\r\n\r\nAfter you have renewed your domain, please login to your client\r\narea and update the expiration date for {{domain_name}}.\r\n\r\nThank You.\r\n\r\nWeb Support Team\r\n\r\nThis message was generate on : {{generate_date}}', '{{domain_name}}|{{expire_date}}|{{generate_date}}|', '');
INSERT INTO `email_templates` VALUES (16, 'New Refered Client Notification', '[16] {{first_name}} just signedup for {{hosting_package}}', 'Hello,\r\n\r\nOn {{generate_date}}, {{first_name}} {{last_name}} signed up for\r\n{{hosting_package}}, referred by you.\r\n\r\nPlease login to your client area to view the monthly commission or \r\none time payout for this referral.\r\n\r\nThank you for the referral.\r\n\r\nWeb Site Support', '{{first_name}}|{{last_name}}|{{hosting_package}}|{{generate_date}}|', '');
INSERT INTO `email_templates` VALUES (17, 'Monthly Affiliate Report', '[17] Monthly Affiliate Status Report', 'Hello,\r\n\r\nBelow you will find your affiliate activity for the month of {{reporting_month}}\r\n\r\n=============================\r\nREFERRALS THIS MONTH: {{referrals_this_month}}\r\n\r\nCURRENT AFFILIATE BALANCE: {{affiliate_balance}}\r\n\r\nTotal Monthly Commissions: {{total_monthly}}\r\nTotal One Time Payouts: {{total_onetimers}}\r\n=============================\r\n\r\nTo view all referrals on your account, please visit your client area and click\r\non the link to the affiliate center.\r\n\r\nThank you.\r\n\r\nWeb Site Support', '{{reporting_month}}|{{referrals_this_month}}|{{affiliate_balance}}|{{total_monthly}}|{{total_onetimers}}|{{generate_date}}|', '');
INSERT INTO `email_templates` VALUES (20, 'Domain Expire: 30 Day Notice', '[20] Your domain expires in 30 days or less', 'Hello,\r\n\r\nYour domain, {{domain_name}} is set to expire on {{expire_date}}.\r\n\r\nThis is a friendly reminder that if your domain expires, your\r\nwebsite and email will fail to work.\r\n\r\nAfter you have renewed your domain, please login to your client\r\narea and update the expiration date for {{domain_name}}.\r\n\r\nThank You.\r\n\r\nWeb Support Team\r\n\r\nThis message was generate on : {{generate_date}}', '{{domain_name}}|{{expire_date}}|{{generate_date}}|', '');
INSERT INTO `email_templates` VALUES (19, 'Monthly Admin Affiliate Report', '[19] Monthly Affiliate Activity Report', 'Below is a summary for {{reporting_month}} affiliate activity\r\n\r\nNew Affiliates: {{new_affiliates_for_reporting_month}}\r\nNew Referrals: {{new_referrals_for_reporting_month}}\r\n\r\nSummary of All Affiliates\r\n\r\n#,   Affiliate Name,     Affiliate ID,   Total Referrals [total],    Balance\r\n{{summary_of_all_affiliates}}\r\nDetail Listing of Affiliate Referrals\r\n\r\nAffiliate ID,  Affiliate Name\r\n{{detail_listing_of_affiliate_referrals}}\r\n\r\nThank You\r\n\r\nYour AutoPilot', '{{reporting_month))|{{new_affiliates_for_reporting_month}}|{{new_referrals_for_reporting_month}}|{{summary_of_all_affiliates}}|{{detail_listing_of_affiliate_referrals}}|', '');
INSERT INTO `email_templates` VALUES (22, 'Domain Expire: Expired', '[22] Your domain has expired', 'Hello,\r\n\r\nYour domain, {{domain_name}} expired on {{expire_date}}.\r\n\r\nThis is a friendly reminder that since your domain expired, your\r\nwebsite and email have failed to work.\r\n\r\nIf you have renewed your domain, please login to your client\r\narea and update the expiration date for {{domain_name}}.\r\n\r\nThank You.\r\n\r\nWeb Support Team\r\n\r\nThis message was generate on : {{generate_date}}', '{{domain_name}}|{{expire_date}}|{{generate_date}}|', '');
INSERT INTO `email_templates` VALUES (23, 'Domain Expire: Invalid Expire Date', '[23] Invalid Expiration date', 'Hello,\r\n\r\nOur records indicate you have put in an invalid expiration date\r\nfor {{domain_name}}.  \r\n\r\nSo we can keep you notified, please login to your client\r\narea and update the expiration date for {{domain_name}}.\r\n\r\nThank You.\r\n\r\nWeb Support Team\r\n\r\nThis message was generate on : {{generate_date}}', '{{domain_name}}|{{expire_date}}|{{generate_date}}|', '');
INSERT INTO `email_templates` VALUES (25, 'Cancel Account: Request Cancel Client Confirm', '[25] Confirmation of Cancellation for {{domain_name}}', 'We have received your request to cancel hosting and billing\r\nfor {{domain_name}}.\r\n\r\nReason for Cancellation: \r\n{{reason_for_cancel}}\r\n\r\nYour cancellation will be processed shortly.\r\n\r\nWe appreciate your business and hope to see you again, soon.\r\n\r\nThank you.\r\n\r\nWeb Support Team\r\n\r\nThis message was generated on: {{generate_date}}', '{{domain_name}}|{{generate_date}}|{{reason_for_cancel}}|', '');
INSERT INTO `email_templates` VALUES (26, 'Cancel Account: Request Revoked', '[26] {{domain_name}} Has withdrawn their cancellation request', '{{domain_name}} has requested to NOT cancel thier hosting account.\r\n\r\nPlease do not process this cancellation.\r\n\r\nReason for Reversing Cancellation: \r\n{{reason_for_revoke}}\r\n\r\nThank you.\r\n\r\nWeb Support Team\r\n\r\nThis message was generated on: {{generate_date}}', '{{domain_name}}|{{generate_date}}|{{reason_for_revoke}}|', '');
INSERT INTO `email_templates` VALUES (27, 'Cancel Account: Account Cancelled', '[27] Cancellation complete for {{domain_name}}', 'We have processed your request to cancel hosting and billing\r\nfor {{domain_name}}.\r\n\r\nReason for Cancellation: \r\n{{reason_for_cancel}}\r\n\r\nYour cancellation was completed on {{cancel_date_time}}.\r\n\r\nWe appreciate your business and hope to see you again, soon.\r\n\r\nThank you.\r\n\r\nWeb Support Team\r\n\r\nThis message was generated on: {{generate_date}}', '{{domain_name}}|{{generate_date}}|{{reason_for_cancel}}|{{cancel_date_time}}|', '');
INSERT INTO `email_templates` VALUES (28, 'Affiliate Commission Paid', '[28] Your commission has been paid', 'Hello,\r\n\r\nThe site admin has just confirmed payment for your affiliate balance in the amount of {{payout_amount}}.  You should be receiving this payment shortly via PayPal or by check.\r\n\r\nThank you.\r\n\r\nWeb Team Support\r\n\r\nThis message was generated on: {{generate_date}}', '{{payout_amount}}|{{generate_date}}|', '');
INSERT INTO `email_templates` VALUES (29, 'Reports: Weekly Sales', '[29] Weekly Sales Report', '=================================================\r\nWEEKLY SALES REPORT FOR {{site_name}}\r\n=================================================\r\n\r\nTotal New Signups: [{{signup_count}}]\r\n\r\nDetail:\r\n\r\n{{new_signups}}\r\n\r\nThis message was generated on: {{generate_date}}', '{{site_name}}|{{generate_date}}|{{new_signups}}|{{signup_count}}|', '');
INSERT INTO `email_templates` VALUES (30, 'Reports: Revenue per Server', '[30] Recurring Revenue per Server Report', '=================================================\r\nRECURRING REVENUE PER SERVER FOR {{site_name}}\r\n=================================================\r\n\r\n{{server_details}}\r\n\r\nThis message was generated on: {{generate_date}}', '{{site_name}}|{{server_details}}|{{generate_date}}|', '');
INSERT INTO `email_templates` VALUES (31, 'Reports: Monthly New Accounts', '[31] Monthly New Account Summary', '=================================================\r\nNEW ACCOUNTS FOR {{site_name}} FOR {{month}}\r\n=================================================\r\n\r\nTotal New Signups: [{{signup_count}}]\r\n\r\nDetails:\r\n{{signup_details}}\r\n\r\nThis message was generated on: {{generate_date}}', '{{site_name}}|{{month}}|{{signup_count}}|{{signup_details}}|{{generate_date}}|', '');
INSERT INTO `email_templates` VALUES (32, 'Max. Clients/Server Reached - No Rotation', '[32] {{server_name}} has reach capaicty', 'Hello,\r\n\r\nYou have reached {{max_accounts}} clients on {{server_name}}. The server is full.\r\n\r\nWe will continue to install accounts on this server until you login to the admin area and define a new active or manual install server.\r\n\r\nThank You.\r\n\r\nYour AutoPilot\r\n\r\nThis message was generated on: {{generate_date}}', '{{max_accounts}}|{{server_name}}|{{generate_date}}|', '');
INSERT INTO `email_templates` VALUES (33, 'Resend Password: Client Side', '[33] Account Login Information', 'Greetings,\r\nSomeone, possibly you, requested account login information for this email address which is associated with a user account at {{site_name}}.\r\n\r\nBelow is your account information:\r\n    \r\nUsername: {{username}}\r\nPassword: {{password}}\r\n\r\nNetwork Operations Team\r\n{{site_name}}\r\n\r\nThis message was generated on: {{generate_date}}', '{{generate_date}}|{{site_name}}|{{username}}|{{password}}|', '');
INSERT INTO `email_templates` VALUES (34, 'Reseller Welcome Email', '[34] Your reseller account has been activated, please save and print', 'Hello {{first_name}},\r\n\r\n////////~~~~~~~~~~[ DETAILS ]~~~~~~~~~~/////////\r\n\r\nYour Package: {{package}}\r\nTotal Quota: {{space}}\r\nTotal Bandwidth: {{bandwidth}}\r\nAccounts Included: {{accounts}}\r\n\r\nThis account is installed on {{server_name}}\r\n\r\n////////~~~~~~~~~~~~~~~~~~~~~~~~~~~/////////\r\n\r\nThe next areas describe how to access your WHM and cPanel.\r\n\r\nPlease print this email for your records.\r\n\r\n------------------------------------------------------------------------\r\nWeb Host Manager Quicky\r\n------------------------------------------------------------------------\r\nTo Create a new account:\r\n\r\nTo access your Web Host Manager, use the following address:\r\n\r\nhttp://{{ip}}:2086\r\n\r\nUsername: {{username}}\r\nPassword: {{password}}\r\n\r\nFirst thing you need to do is scroll down on the left and click on \\\'Add Package\\\'\r\nso that you can create your own hosting packages.  You cannot install a domain\r\nonto your account without a package created.\r\n\r\n1. - click on \\\'Create a New Account\\\' from the left hand side menu\r\n2. - put the domain in the \\\'Domain\\\' box (no www or http or spaces - just\r\ndomainname.com).  After putting in the domain, it will automatically\r\ncreate a username.\r\n\r\n3. - Your package selection should one that you created earlier\r\n4. - Then press the create button\r\n\r\nThis will create a confirmation page - right click in this area and\r\nselect print (for your records)\r\n\r\n------------------------------------------------------------------------\r\n\r\nPlease do not click on anything that you are not sure what it does.  Please do not\r\ntry to alter the WHM Theme from the selection box - fatal errors will occur.\r\n\r\nYour Domain Information:\r\n\r\nDomain: {{domain}}\r\nIp: {{ip}}\r\nUserName: {{username}}\r\nPassWord: {{password}}\r\n\r\nStarting Space for this domain: 50 megs.  If you need more space, that will deduct\r\nfrom your {{space}} allotted for your client accounts.\r\n\r\nFor FTP:\r\n\r\nHost Address: {{ip}} or {{domain}} if resolved\r\nUsername: {{username}}\r\nPassword: {{password}}\r\n\r\nTo log in to your CPanel (for hosting on this domain) use this address:\r\n\r\nhttp://{{ip}}:2082 or http://{{domain}}:2082 if it has resolved\r\n\r\nUsername: {{username}}\r\nPassword: {{password}}\r\n\r\nUse the IP address if your domain has not resolved to this server yet.\r\nThe http:// must be present in the address to access port :2082\r\n\r\nTo access your Web Host Manager, use the following address:\r\n\r\nhttp://{{ip}}:2086\r\n\r\nUsername: {{username}}\r\nPassword: {{password}}\r\n\r\nYour domain, when you chose one, or if you already have it registered\r\nneeds to point to the following nameservers:\r\n\r\n{{primary_nameserver}}\r\n---> {{primary_nameserver_ip}}\r\n{{secondary_nameserver}}\r\n---> {{secondary_nameserver_ip}}\r\n\r\nAll of your clients will need to point here as well to be hosted in your\r\nreseller block of the server.\r\n\r\nIf you ordered private label nameservers, here is the needed information to register them:\r\n\r\n{{primary_nameserver_reseller}} resolves to {{primary_nameserver_ip_reseller}}\r\n{{primary_nameserver_ip_reseller}} resolves to {{secondary_nameserver_ip_reseller}}\r\n\r\nPlease remember, these will require a server A Record to be created.  Please notify support as soon as these are registered or they will not work.\r\n\r\nThanks,\r\n\r\nSupport Team\r\nWeb Hosting Company\r\n\r\n\r\n============================================================\r\nBRIEF OVERVIEW / TUTORIAL of the WHM\r\n============================================================\r\n\r\nlot of the features in the WHM will be used daily, some may not ever be\r\nused at all. This email will explain the first few menu options on the left\r\nas soon as you login to your WHM.\r\n\r\nTo login, use the following method:\r\n\r\nhttp://{{ip}}:2086\r\n\r\nusername: {{username}}\r\npassword: {{password}}\r\n\r\nthe http:// must be in the address line to connect to port :2086\r\n\r\nLet\\\'s begin:\r\n\r\n============================================================================\r\nWeb Host Manager Tutorial / Explanation\r\n----------------------------------------------------------------------------\r\n\r\nThe web host manager (WHM) is your gateway to the server for installation\r\nand managing of your reseller accounts. I have broken down the WHM in\r\nsections below, with explanations of each feature and what it is good for.\r\n\r\nServer Setup\r\n------------------------------------------------\r\nSetup Remote Access Key\r\n------------------------------------------------\r\nThis function creates a secure key code that will allow perl programs (still\r\nin development) to communicate to your WHM to install,modify and delete\r\nclients without accessing the WHM.  This feature is something that is in\r\ndevelopment and would not be a used feature for your program at this time.\r\n\r\nServer Status\r\n------------------------------------------------\r\nServices Status\r\n------------------------------------------------\r\nThis will allow you to view the heath of the server, at any time.  By\r\nclicking on this link, you will be able to see all the server services\r\nrunning, their status and their usage.  Yellow lights are ok - red lights\r\nare acceptable as long as it is not for long periods of time.  We also\r\nmanage and view these services. If you see a problem, 99% of the time we are\r\nalready addressing it.\r\n\r\n------------------------------------------------\r\nServer Information\r\n------------------------------------------------\r\nThis allows you to see what makes the server.  The processors, hard drive,\r\nserver name, disk usage, etc.\r\n\r\nAccount Functions\r\n------------------------------------------------\r\nList Accounts\r\n------------------------------------------------\r\nThis shows all of your client domains, Server IP, Username, Install Date,\r\nand Space used.  This feature will not show you your clients QUOTA since you\r\nwill be modifying this (if needed) from the \\\'Quota Modification\\\' section\r\ndiscussed later.\r\n\r\n------------------------------------------------\r\nCreate a New Account\r\n------------------------------------------------\r\nThis one is pretty much self explanatory but there are some items that need\r\nto be looked out for while installing clients onto the server.\r\n\r\n1 - There cannot be any spaces before or after the domain name.  All that is\r\nneeded is this block is just the domain name (no www. or http://)\r\n\r\n2 - The username cannot start with a number or have any spaces or dashes in\r\nit.  If the username defaults to a name with a dash, remove the dash or\r\nerrors will occur when the user attempts to install scripts included in the\r\nCPanel.\r\n\r\nBad usernames: 123domai or 123-doma or domain-\r\nGood Usernames: domainco or domainxx or domainqt\r\n\r\nTry to keep the username all lower case, as well as the password when you\r\ncreate it.\r\n\r\nTo install a new account, follow these steps:\r\n\r\n1 - input the client domain into the domain box - this will automatically\r\ncreate a username after you press the TAB key when done.  If the username\r\nhas a - in it or starts with a number, please modify the username to be a\r\nclean, acceptable username.\r\n\r\n2 - Create password for the user.  This can be whatever you wish to have as\r\nthe password or the user can request a specific password when signing up for\r\nservices.  A good rule of thumb is to not use an everyday word or, if you\r\nuse an everyday word like \\\'tree\\\', modify it with a few numbers -\r\n\\\'tree78787\\\'.\r\n\r\n3 - Select your default package (there will only be one package in your\r\ndropdown) and press the create button at the top.\r\n\r\nYour default package will only install the account on 10 megs of space.  If\r\nyou need to modify this space, use the \\\'Quota Modification\\\' feature\r\nexplained later.\r\n\r\n********GOOD RULE OF THUMB***********\r\nAfter you press the create button, a confirmation page will come up showing\r\nthe domain installed, the IP, the username and password.  Right click on\r\nthis page and select the print option.  Keep this in your file for this user\r\nsince this will be your only record of the users original password.\r\n*************************************\r\n\r\n------------------------------------------------\r\nSkeleton Directory\r\n------------------------------------------------\r\nThis directory is where you would install a basic index.html page that would\r\nbe installed on all new domains after you have installed them -\r\nautomatically.  If you want to use this feature, you must first click on\r\nthis link to create the cpanel3-skel directory on your reseller domain.\r\n\r\n1 - Create a simple index.html page - Hosted by ______________________ or\r\nsomething a little more feature rich.  If you are using images, host the\r\nimages somewhere else and use full url links to the images IMG\r\nSRC=\\"http://yourdomain.com/images/welcome.gif\\".\r\n\r\n2 - FTP into your main domain and open the /cpanel3-skel folder.  Then open\r\nthe /public_html folder.\r\n\r\n3 - Upload your basic index.html page into this folder.  THAT\\\'S IT!\r\nEverytime you install an account, this index page will be installed onto\r\nthat domain.  Once the domain resolves, your page will be seen.  The user\r\ncan delete or replace them at their own desire.\r\n\r\n------------------------------------------------\r\nTerminate an Account\r\n------------------------------------------------\r\nPretty much self explanatory.  Only one word of caution - FILES ARE NOT\r\nRECOVERABLE AFTER TERMINATION.\r\n\r\n------------------------------------------------\r\nView Bandwidth Usage\r\n------------------------------------------------\r\nAgain, pretty much self explanatory.  This feature will give you a summary\r\nof all your clients bandwidth usage for the current month.  You have the\r\nability to preview previous months by clicking on the link at the top of the\r\nbandwidth page.  If you notice a client with a highlighted listing (yellow\r\nor red) - Keep an eye on them for they are using alot of bandwidth.\r\n\r\n------------------------------------------------\r\nLimit Bandwidth Usage\r\n------------------------------------------------\r\nIf you want to limit the bandwidth per account, you can do so here.  This is\r\ncounted in MEGS of bandwidth so make sure you use the following method:\r\n\r\nFor 1 GIG of Bandwidth, use 1024 megs, etc.\r\n\r\nOnce this account goes over 1 gig in bandwidth, a page will show up on their\r\ndomain stating bandwidth limit has been reached, contact system admin.  This\r\ngives you total control over bandwidth so nothing gets out of hand.\r\n\r\n------------------------------------------------\r\nSuspend or Unsuspend and account & List Suspended Accounts\r\n------------------------------------------------\r\nSelf explanatory area.  This will allow you to FREEZE a clients domain which\r\nwill product a customized (explained later) page on their website stating\r\nthey have been suspended, please contact system admin.\r\n\r\n------------------------------------------------\r\nModify Suspended Account Page\r\n------------------------------------------------\r\nClicking this will give you a form field with the HTML code of your \\\'Account\r\nSuspended\\\' page.  Create a standard \\\'account suspended\\\' web page (with full\r\nurl links to images) in a normal web design program. Cut and paste the\r\nsource into this box and press save.\r\n\r\n------------------------------------------------\r\nQuota Modification\r\n-------------------------------------------------\r\nAfter you install and account, and they have been assigned 10 megs on your\r\nreseller area - you can click here to alter that space to meet their needs.\r\nPretty much self explanatory once inside.  Find the domain, replace the 10\r\nwith what they purchases and press the submit button next to the box.\r\n\r\n------------------------------------------------\r\nPassword Modification\r\n------------------------------------------------\r\nIf a user misplaces or forgets their password, you can go here and either\r\nreset it to original (pull out copy of printout from account creation) or\r\nyou can make an entire new password for them.\r\n\r\n------------------------------------------------\r\nList Subdomains\r\n------------------------------------------------\r\nIf an account has been enabled to use sub-domains (unique IP required) - you\r\nwill be able to view all the sub-domains by clicking this link for all\r\naccounts in your reseller block.\r\n\r\n============================================================================', '{{first_name}}|{{package}}|{{space}}|{{bandwidth}}|{{accounts}}|{{server_name}}|{{domain}}|{ip}}|{{username}}|{{password}}|{{generate_date}}|{{primary_nameserver}}|{{primary_nameserver_ip}}|{{secondary_nameserver}}|{{secondary_nameserver_ip}}|{{primary_nameserver_reseller}}|{{primary_nameserver_ip_reseller}}|{{secondary_nameserver_reseller}}|{{secondary_nameserver_ip_reseller}}|', '');
INSERT INTO `email_templates` VALUES (36, 'Dedicated Server Activation', '[36] Your Dedicated Server has been Activated and is Ready', 'Hello {{first_name}},\r\n\r\n////////~~~~~~~~~~[ DETAILS ]~~~~~~~~~~/////////\r\n\r\nServer Name: {{dedicated_server_name}}\r\n\r\nOperating System: {{dedicated_operating_system}}\r\nServer Specifications: {{dedicated_server_specs}}\r\n\r\nMain IP: {{dedicated_main_ip}}\r\nInitial IP Allocation: {{dedicated_ipblock_range}}\r\n\r\nRoot Access Password: {{dedicated_root_password}}\r\n\r\nThis servers rack location is: {{dedicated_rack_location}}\r\n\r\n////////~~~~~~~~~~~~~~~~~~~~~~~~~~~/////////\r\n\r\nThe next areas describe how to access your WHM\r\n\r\nAVAILABLE DOCUMENTATION:\r\n\r\nCPanel Manual: http://www.cpanel.net/docs/cp/\r\nWebHostManager Manual: http://www.cpanel.net/docs/whm/\r\n\r\nAutomate your client installs immediately after they order, visit:\r\nhttp://www.whmautopilot.com/autopilot.php\r\n\r\nPlease print this email for your records.\r\n\r\n------------------------------------------------------------------------\r\nFIRST STEPS TO GET THIS SERVER UP AND RUNNING\r\n------------------------------------------------------------------------\r\n\r\nThis server has been built to \\\'standard\\\' specifications and no specific\r\n\\\'user\\\' related information may be in place.\r\n\r\nStep One:\r\n\r\nLog into your Dedicated Servers ROOT WHM:\r\n\r\nhttps://{{dedicated_main_ip}}:2087/\r\n\r\nRoot Password: {{dedicated_root_password}}\r\nUsername: root\r\n\r\n[1] Click on \\\'Edit Setup\\\' on the left hand frame\r\n\r\n(A)--->   make sure primary and secondary nameservers are correct\r\n If yes, assign an IP and create the A record (each)\r\n\r\n(B)--->  make sure hostname is correct.  If not, make a note and we\\\'ll discuss\r\n    how to change that later.\r\n\r\n(C)--->    If you have AOL IM, we highly recommend putting that information in\r\n here so that you can be alerted via AOL IM if something has a problem.\r\n\r\nAfter all these have been reviewed, and found to be correct - click submit at the\r\nbottom of this page to save your changes to this area.\r\n\r\n[2] With the above done, and the A Records made for your private nameservers,\r\nyou will need to register those with your domain registrar.\r\n\r\n[3] Get to know your WHM by using the manual link above and please, if you do not\r\nknow what something does - do not click it.\r\n\r\nRemember, you have root access to this box and that access should never be shared\r\nnor given to anyone outside of your trust limits.  Root access controls all the \r\nconfigurations of the server and, with the wrong command or edit, can crash your \r\nserver and entail costs of $75 per man hour to correct.\r\n\r\n------------------------------------------------------------------------\r\nBASIC ROOT COMMANDS FOR A DEDICATED SERVER - USE AT YOUR OWN RISK\r\n------------------------------------------------------------------------\r\n\r\nThese commands are to be run in an SSH Window via login to port 22 as root\r\n\r\nA good program for this is called PuTTY\r\n\r\n-----------------------\r\nTo restart server    : reboot\r\nCheck Disk Usage    : dj -k\r\nStop HTTPD (apache)  : /etc/rc.d/init.d/httpd stop\r\nStart HTTPD (apache)   : /ect/rc.d/init.d/httpd start\r\nRestart HTTPD (apache)    : httpd restart\r\nView current processes   : top\r\nDisplay a file     : cat /path/to/filename\r\nEditing a file       : pico /path/to/filename\r\nDomain Name Lookup  : fwhois yourname.com\r\nPing IP/Domain     : ping domain.com or ping 000.000.000.000\r\nRecompile Apache   : /scripts/easyapache (use with caution)\r\nFixing Disk Quotas  : /scripts/fixquotas\r\n-----------------------\r\n\r\nBasic File/Script Locations on the server:\r\n\r\nAdmin control scripts  : /scripts\r\nAdmin control interface   : /scripts/admin\r\nWeb Account Directory   : /home/username/\r\nAccess/Error logs  : /usr/local/apache/logs\r\nDomain Access Logs  : /usr/local/apache/domlogs\r\nApache Conf File : /etc/httpd/conf/httpd.conf\r\n\r\nWe ask that you use any script on the server with caution understanding\r\nthat anything you do affects all of your users on the server.  If there\r\nare any scripts/processes found on this server that breaches the AUP for\r\nthis service, they will be removed/stopped and you could lose root access\r\nto your server.\r\n\r\nIf you have any questions, please, don\\\'t hestiate to contact our support\r\nteam.\r\n\r\nThanks,\r\n\r\nSupport Team\r\nWeb Hosting Company', '{{first_name}}|{{dedicated_rack_location}}|{{dedicated_root_password}}|{{dedicated_ipblock_range}}|{{dedicated_main_ip}}|{{dedicated_server_specs}}|{{dedicated_operating_system}}|{{dedicated_server_name}}|', '');
INSERT INTO `email_templates` VALUES (37, 'Invoice Paid Successfully', '[37] Hosting Invoice #{{invoice_number}} is paid', 'Greetings,\r\nOn {{date_paid}}, {{first_name}} {{last_name}} paid invoice #{{invoice_number}} in the amount of {{total_invoice_amount}}. \r\n\r\nPlease visit your AutoPilot for the invoice details.\r\n\r\nThanks\r\nYour AutoPilot\r\n\r\nThis email was generated on: {{generate_date}}', '{{invoice_number}}|{{date_paid}}|{{first_name}}|{{last_name}}|{{invoice_number}}|{{total_invoice_amount}}|', '');
INSERT INTO `email_templates` VALUES (38, 'Invoice Ready Notification to Client', '[38] Your Invoice is Ready', 'Greetings {{first_name}},\r\n\r\nPlease visit the URL to view and pay this invoice.\r\n    \r\n{{pay_link}}\r\n\r\nThanks,\r\nWeb Support Team\r\n \r\nThis email was generated on: {{generate_date}}', '{{first_name}}|{{pay_link}}|{{generate_date}}|', '');
INSERT INTO `email_templates` VALUES (39, 'Invoice Due in X Days Notice', '[39] Your account is due in {{days_until_due}}', 'Greetings {{first_name}},\r\n\r\nYour account, {{domain_name}}, is due in {{days_until_due}} and will be billed for {{total_recuur}} via {{payment_processor}}.\r\n                \r\nNo action is required on your part, this is just a reminder.\r\n                \r\nThanks,\r\nWeb Support Team\r\n         \r\nThis email was generated on: {{generate_date}}', '{{days_until_due}}|{{first_name}}|{{domain_name}}|{{total_recuur}}|{{payment_processor}}|{{generate_date}}|', '');
INSERT INTO `email_templates` VALUES (40, 'Incomplete Order Notification', '[40] You have incomplete orders', 'Hello, \r\nYou currently have {{incomplete_orders}} order(s) in the incomplete orders area of your AutoPilot. \r\n\r\nPlease login to your admin area to view/process these orders. \r\n\r\nThank you. \r\nYour AutoPilot \r\n\r\nThis message was generated on: {{generate_date}}', '{{incomplete_orders}}|{{generate_date}}|', '');
INSERT INTO `email_templates` VALUES (41, 'Daily Invoice Summary Report', '[41] Daily Invoice Summary Report', 'Hello,\r\n\r\nBelow is a list of hosting order invoices in the system that are either past due or unpaid past due.\r\n\r\nPlease login to your admin area and go to the invoice management area to update the status of these invoices.\r\n\r\nSome of these may have just rotated into a new billing cycle and have been billed by the proper gateway.  If this has\r\nhappened, verify payment was made at the gateway and update the invoice as paid in your system.  Marking them as paid\r\nwill reset the next due date accordingly for the hosting order.\r\n\r\n*** Past Due Invoices as of {{generate_date}} Seperated by Payment Gateway ***\r\n\r\n{{mail_in_summary}}{{paypal_summary}}{{paysystems_summary}}{{authorize.net_summary}}{{2checkout}}{{worldpay_summary}}', '{{generate_date}}|{{mail_in_summary}}|{{paypal_summary}}|{{paysystems_summary}}|{{authorize.net_summary}}|{{2checkout}}|{{worldpay_summary}}|', '');
INSERT INTO `email_templates` VALUES (42, 'Daily Billable Service Invoice Summary Report', '[42] Daily Invoice Summary Report', 'Hello,\r\n\r\nBelow is a list of billable service invoices in the system that are either past due or unpaid past due.\r\n\r\n*** UnPaid and Past Due Invoices as of {{generate_date}} Seperated by Payment Gateway ***\r\n\r\n{{mail_in_summary}}{{paypal_summary}}{{paysystems_summary}}{{authorize.net_summary}}{{2checkout}}{{worldpay_summary}}', '{{generate_date}}|{{mail_in_summary}}|{{paypal_summary}}|{{paysystems_summary}}|{{authorize.net_summary}}|{{2checkout}}|{{worldpay_summary}}|', '');
INSERT INTO `email_templates` VALUES (43, 'Domain Registration Notice', '[43] Domain Registration Requested for {{domain_name}}', 'Hello Admin,\r\n\r\nOn, {{generate_date}}, {{first_name}} {{last_name}} ordered hosting that included the registration of a domain name.\r\n\r\nDomain: {{domain_name}}\r\nCost Agreed: {{domain_reg_price}} per year\r\n\r\nRegistrant Information:\r\n\r\n{{first_name}} {{last_name}}\r\n{{company_name}}\r\n{{address_1}}\r\n{{address_2}}\r\n{{city}} {{state}}, {{zip}}\r\n{{phone}}\r\n{{fax}}\r\n\r\nPlease register this domain for the client immediately and make sure the nameservers placed in at the time of order are:\r\n\r\n{{primary_ns}}\r\n{{primary_ns_ip}}\r\n\r\n{{secondary_ns}}\r\n{{secondary_ns_ip}}\r\n\r\nThis client has NOT been charged for this domain registration. Please login to your admin area after successful\r\nregistration and invoice the client from your non-hosting products area for this registration.\r\n\r\nThank you.\r\n\r\nYour AutoPilot\r\n\r\nMessage Generated on: {{generate_date}}', '{{domain_name}}|{{generate_date}}|{{first_name}}|{{last_name}}|{{domain_reg_price}}|{{company_name}}|{{address_1}}|{{address_2}}|{{city}}|{{state}}|{{zip}}|{{phone}}|{{fax}}|{{primary_ns}}|{{primary_ns_ip}}|{{secondary_ns}}|{{secondary_ns_ip}}|{{email_address}}|', '');
INSERT INTO `email_templates` VALUES (44, 'Support Ticket Opened by Client', '[44] {{first_name}} {{last_name}} has opened a new support ticket [ Ticket # {{ticket_number}} ]', 'Hello,\r\n\r\nA new support request has been logged by a user.\r\n\r\nHere are the details:\r\n\r\nTicket #{{ticket_number}}\r\n---------------------------\r\n{{ticket_details}}\r\n---------------------------\r\n\r\nPlease login to your admin area to respond to this ticket.\r\n\r\nThank you.\r\n\r\nYour AutoPilot\r\n\r\nGenerated on {{generate_date}}', '{{first_name}}|{{last_name}}|{{ticket_number}}|{{ticket_details}}|{{generate_date}}|', '');
INSERT INTO `email_templates` VALUES (45, 'Client Reply to Support Ticket', '[45] {{first_name}} {{last_name}} has replied to ticket [ Ticket # {{ticket_number}} ]', 'Hello,\r\n\r\nA response from the client has been made on the following ticket, details below:\r\n\r\nHere are the details:\r\n\r\nTicket #{{ticket_number}}\r\n---------------------------\r\n{{ticket_details}}\r\n---------------------------\r\n\r\nPlease login to your admin area to respond to this ticket.\r\n\r\nThank you.\r\n\r\nYour AutoPilot\r\n\r\nGenerated on {{generate_date}}', '{{first_name}}|{{last_name}}|{{ticket_number}}|{{ticket_details}}|{{generate_date}}|', '');
INSERT INTO `email_templates` VALUES (46, 'Admin Reply to Support Ticket', '[46] [ Ticket # {{ticket_number}} ] Reply to support ticket', 'Hello,\r\n\r\nBelow is the tech reply to your support request\r\n\r\nTicket #{{ticket_number}}\r\n---------------\r\n{{admin_reply_details}}\r\n---------------\r\n\r\n\r\nPlease do not reply directly to this email but login to your client area and update your request from your ticket\r\nmanagement area in that location.\r\n\r\nIf you feel this reply resolved your situation, please be sure to close your ticket from your client area.\r\n\r\nThank You.\r\n\r\nSupport Team\r\n\r\nGenerated on {{generate_date}}', '{{admin_reply_details}}|{{ticket_number}}|{{ticket_details}}|{{generate_date}}|', '');
INSERT INTO `email_templates` VALUES (47, 'Admin Domain Registration E-mail', '[47] eNom Domain Registration - {{domain_name}}', 'Hello,\r\n\r\nBelow are the results of an automated registration through your eNom account.\r\n\r\nOrder ID: {{enom_order_id}}\r\nResponse:\r\n{{enom_response_code}}\r\n\r\nDomain Name: {{domain_name}}\r\nDomain Expiration: {{expiration_date}} * approximate date\r\n\r\nRegistrant Information:\r\n{{first_name}} {{last_name}}\r\n{{address_1}}\r\n{{address_2}}\r\n{{city}} {{state}} {{zip}} {{country}}\r\n{{phone}}\r\n{{fax}}\r\n\r\nIf this registration was successful, there are no actions needed on your part. If there was an error given in the response above, manual registration may need to be completed for this domain.\r\n\r\nThank You\r\n\r\nYour AutoPilot\r\n\r\nMessage Generated on: {{generate_date}}', '{{domain_name}}|{{enom_order_id}}|{{enom_response_code}}|{{expiration_date}}|{{first_name}}|{{last_name}}|{{address_1}}|{{address_2}}|{{city}}|{{state}}|{{country}}|{{zip}}|{{phone}}|{{fax}}|{{generate_date}}|', '');
INSERT INTO `email_templates` VALUES (48, 'Payment Processor Returned Transaction Data', '[48] Gateway Response for {{domain_name}} from {{payment_gateway}}', 'Hello,\r\n\r\nBelow are the results for the hosting order for {{domain_name}} paid through {{payment_gateway}}.\r\n\r\nThis email should be used for troubleshooting any problems that may have arose during the order process or to be stored as a record of the inital response from the gateway.\r\n\r\n{{post_data}}\r\n\r\nThank you.\r\n\r\nYour AutoPilot\r\n\r\nGenerated on: {{generate_date}}', '{{domain_name}}|{{payment_gateway}}|{{post_data}}|{{generate_date}}', '');
INSERT INTO `email_templates` VALUES (49, 'Invalid Admin Login Attempt', '[49] Invalid Admin Login on {{generate_date}}', 'Hello,\r\n\r\nOn {{generate_date}}, access to your admin area was attempted but failed.\r\n\r\nIP: {{users_ip}}\r\nUsername: {{username}}\r\nPassword Attempted: {{password_attempt}}\r\n\r\nThank you.\r\n\r\nYour AutoPilot.\r\n\r\nGenerated on: {{generate_date}}', '{{generate_date}}|{{users_ip}}|{{username}}|{{password_attempt}}', '');
INSERT INTO `email_templates` VALUES (112, 'Offline Credit Card Confirmation', '[112] Confirmation Information for {{client_name}} on {{generate_date}}', 'Client Information:\r\n\r\n{{name}}\r\n{{address1}}\r\n{{city}}, {{state}}  {{zip}}\r\n{{country}}\r\n\r\nPhone: {{phone}}\r\nFax: {{fax}}\r\nEmail: {{email}}\r\n\r\n====================\r\nCard Number: {{cardnumber}}  Exp: {{cardexpmonth}} / {{cardexpyear}}\r\nCard Type: {{cardtype}}\r\n====================\r\n\r\nDomains: {{comments}}\r\nBilling Cycle: {{periodicity}}\r\n\r\nCharge Total Today: {{charge_total}}\r\nTotal to Reoccur: {{recurring_amount}}\r\n\r\n===========================', '{{generate_date}}|{{client_name}}|{{comments}}|{{periodicity}}|{{cardnumber}}|{{cardtype}}|{{cardexpmonth}}|{{cardexpyear}}|{{name}}|{{address1}}|{{city}}|{{state}}|{{country}}|{{phone}}|{{fax}}|{{email}}|{{zip}}|{{charge_total}}|{{recurring_amount}}', '');
# --------------------------------------------------------

#
# Table structure for table `hosting_order`
#

CREATE TABLE `hosting_order` (
  `oid` bigint(22) unsigned NOT NULL auto_increment,
  `uid` bigint(22) NOT NULL default '0',
  `txn_id` varchar(255) NOT NULL default '',
  `next_due_date` text NOT NULL,
  `pid` bigint(22) NOT NULL default '0',
  `status` int(1) NOT NULL default '0',
  `reseller` int(1) NOT NULL default '0',
  `domain_name` varchar(255) NOT NULL default '',
  `domain_registration` int(1) NOT NULL default '0',
  `tld_id` bigint(22) NOT NULL default '0',
  `domain_expire` varchar(10) NOT NULL default '',
  `domain_lock` int(4) NOT NULL default '0',
  `payment_method` varchar(10) NOT NULL default '',
  `payment_term` varchar(25) NOT NULL default '',
  `addon_choices` text NOT NULL,
  `ns1` varchar(255) NOT NULL default 'undefined',
  `ns2` varchar(255) NOT NULL default 'undefined',
  `total_due_today` float NOT NULL default '0',
  `total_due_reoccur` float NOT NULL default '0',
  `promotion_code` varchar(255) NOT NULL default '',
  `referrer_id` varchar(255) NOT NULL default '',
  `whm_username` blob NOT NULL,
  `whm_password` blob NOT NULL,
  `whm_id` bigint(22) NOT NULL default '0',
  `ogcreate` int(40) default NULL,
  `ip` varchar(255) NOT NULL default 'undefined',
  `resolved` int(1) NOT NULL default '0',
  `resolved_time` int(40) default NULL,
  `ur_lock` int(1) NOT NULL default '0',
  `ur_date` int(40) default NULL,
  `postback` varchar(255) NOT NULL default '',
  `afuid` bigint(22) NOT NULL default '0',
  `reason_for_revoke` text NOT NULL,
  `reason_for_cancel` text NOT NULL,
  `cancel_date` int(40) default NULL,
  `client_ip` varchar(25) NOT NULL default '',
  `client_host` varchar(255) NOT NULL default '',
  `cont_resolve` int(1) NOT NULL default '1',
  `admin_notes` text NOT NULL,
  `client_notes` text NOT NULL,
  `pns1` varchar(25) NOT NULL default '',
  `pns2` varchar(25) NOT NULL default '',
  `server_hostname` varchar(255) NOT NULL default '',
  `root_pw` varchar(255) NOT NULL default '',
  `server_specs` text NOT NULL,
  `ipblock` text NOT NULL,
  `rack` text NOT NULL,
  `sorp` int(1) NOT NULL default '0',
  `fraudcall_score` varchar(10) NOT NULL default '',
  `linkpoint_recid` varchar(255) NOT NULL default '0',
  `lpid` varchar(22) NOT NULL default '',
  `offcid` varchar(22) NOT NULL default '',
  `fg_call_info` longtext NOT NULL,
  PRIMARY KEY  (`oid`),
  KEY `oid` (`oid`),
  KEY `uid` (`uid`),
  KEY `pid` (`pid`),
  KEY `status` (`status`)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

#
# Dumping data for table `hosting_order`
#


# --------------------------------------------------------

#
# Table structure for table `invoice`
#

CREATE TABLE `invoice` (
  `iid` bigint(22) unsigned NOT NULL auto_increment,
  `uid` bigint(22) NOT NULL default '0',
  `oid` bigint(22) NOT NULL default '0',
  `due_date` int(10) NOT NULL default '0',
  `payment_method` int(3) NOT NULL default '0',
  `txn_id` varchar(255) NOT NULL default '',
  `additional_information` text NOT NULL,
  `invoice_details` text NOT NULL,
  `invoice_terms` int(2) NOT NULL default '0',
  `status` int(11) NOT NULL default '0',
  `created` int(10) NOT NULL default '0',
  `date_paid` int(10) NOT NULL default '0',
  `invoice_number` bigint(22) NOT NULL default '0',
  `invoice_type` int(1) NOT NULL default '0',
  `total_due_today` float NOT NULL default '0',
  `total_due_reoccur` float NOT NULL default '0',
  `charge_tax` float NOT NULL default '0',
  `tax_type` char(3) NOT NULL default '',
  `extras` text NOT NULL,
  `master` int(11) NOT NULL default '0',
  `checkout_id` varchar(25) NOT NULL default '',
  PRIMARY KEY  (`iid`)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

#
# Dumping data for table `invoice`
#


# --------------------------------------------------------

#
# Table structure for table `invoice_config`
#

CREATE TABLE `invoice_config` (
  `logo_path` varchar(255) NOT NULL default '',
  `company_contact` mediumtext NOT NULL,
  `payable_to` varchar(255) NOT NULL default '',
  `invoice_number` bigint(22) NOT NULL default '1000'
) TYPE=MyISAM;

#
# Dumping data for table `invoice_config`
#

INSERT INTO `invoice_config` VALUES ('', 'www.company.co.uk\r\n123 Mocking Bird Lane\r\nSomeTown, State Zip USA\r\nRegistered company number: 3xxxxx763\r\nVAT number: 7xxxxxx2', 'Your Business', 1000);

# --------------------------------------------------------

#
# Table structure for table `invoice_service`
#

CREATE TABLE `invoice_service` (
  `srid` bigint(22) unsigned NOT NULL auto_increment,
  `service_name` varchar(255) NOT NULL default '',
  `service_description` text NOT NULL,
  `service_show_description` int(1) NOT NULL default '0',
  `service_cost` float NOT NULL default '0',
  PRIMARY KEY  (`srid`)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

#
# Dumping data for table `invoice_service`
#


# --------------------------------------------------------

#
# Table structure for table `invoice_session`
#

CREATE TABLE `invoice_session` (
  `sid` text NOT NULL,
  `created` int(10) NOT NULL default '0'
) TYPE=MyISAM;

#
# Dumping data for table `invoice_session`
#


# --------------------------------------------------------

#
# Table structure for table `linkpoint_holding_queue`
#

CREATE TABLE `linkpoint_holding_queue` (
  `lpid` bigint(22) unsigned NOT NULL auto_increment,
  `sid` varchar(32) NOT NULL default '',
  `oid` bigint(22) NOT NULL default '0',
  `uid` bigint(22) NOT NULL default '0',
  `startdate` text NOT NULL,
  `chargetotal` float NOT NULL default '0',
  `periodicity` text NOT NULL,
  `thisgoesin` varchar(255) default NULL,
  `comments` varchar(255) default NULL,
  `cardnumber` varchar(255) NOT NULL default '0',
  `cardexpmonth` varchar(255) NOT NULL default '0',
  `cardexpyear` varchar(255) NOT NULL default '0',
  `ip` varchar(255) default NULL,
  `name` varchar(255) default NULL,
  `address1` varchar(255) default NULL,
  `city` varchar(255) default NULL,
  `state` varchar(255) default NULL,
  `country` varchar(255) default NULL,
  `phone` varchar(255) default NULL,
  `fax` varchar(255) default NULL,
  `email` varchar(255) default NULL,
  `zip` varchar(255) default NULL,
  `linkpoint_type` varchar(32) NOT NULL default '',
  `status` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`lpid`)
) TYPE=MyISAM COMMENT='Recurring queue for LinkPoint' AUTO_INCREMENT=1 ;

#
# Dumping data for table `linkpoint_holding_queue`
#


# --------------------------------------------------------

CREATE TABLE `offline_holding_queue` (
  `offcid` bigint(22) unsigned NOT NULL auto_increment,
  `sid` varchar(32) NOT NULL default '',
  `oid` bigint(22) NOT NULL default '0',
  `uid` bigint(22) NOT NULL default '0',
  `startdate` text NOT NULL,
  `chargetotal` float NOT NULL default '0',
  `recurringamount` float NOT NULL default '0',
  `periodicity` text NOT NULL,
  `comments` varchar(255) default NULL,
  `cardnumber` varchar(255) NOT NULL default '0',
  `cardexpmonth` varchar(255) NOT NULL default '0',
  `cardexpyear` varchar(255) NOT NULL default '0',
  `ip` varchar(255) default NULL,
  `name` varchar(255) default NULL,
  `address1` varchar(255) default NULL,
  `city` varchar(255) default NULL,
  `state` varchar(255) default NULL,
  `country` varchar(255) default NULL,
  `phone` varchar(255) default NULL,
  `fax` varchar(255) default NULL,
  `email` varchar(255) default NULL,
  `zip` varchar(255) default NULL,
  `status` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`offcid`)
) TYPE=MyISAM COMMENT='Holding Queue for offline processor' AUTO_INCREMENT=1 ;

#
# Table structure for table `payment_process`
#

CREATE TABLE `payment_process` (
  `pid` int(11) unsigned NOT NULL auto_increment,
  `demo` int(1) NOT NULL default '0',
  `name` varchar(255) NOT NULL default '',
  `x_gateway` varchar(255) NOT NULL default '',
  `x_Login` varchar(255) NOT NULL default '',
  `x_Password` varchar(255) NOT NULL default '',
  `x_Currency_Code` varchar(5) NOT NULL default '',
  `x_fields` text NOT NULL,
  `paypal_address` varchar(255) NOT NULL default '',
  `paypal_image_url` varchar(255) NOT NULL default '',
  `checkout_sid` varchar(255) NOT NULL default '',
  `co_system` tinyint(1) NOT NULL default '0',
  `paysystems_companyid` varchar(255) NOT NULL default '',
  `linkpoint_storeid` varchar(255) NOT NULL default '',
  `linkpoint_type` varchar(255) NOT NULL default '',
  `psigate_merchant` varchar(64) NOT NULL default '',
  `psigate_chargetype` char(2) NOT NULL default '0',
  `psigate_emailclient` varchar(4) NOT NULL default '',
  `internetsecure_merchant_id` varchar(25) NOT NULL default '',
  `internetsecure_language` varchar(100) NOT NULL default '',
  `internetsecure_return_cgi` varchar(255) NOT NULL default '',
  `worldpay_id` varchar(255) NOT NULL default '',
  `worldpay_cc` varchar(6) NOT NULL default '',
  `worldpay_demo` int(3) NOT NULL default '0',
  `worldpay_callback` varchar(255) NOT NULL default '',
  `plugnpay_subject` varchar(255) NOT NULL default '',
  `plugnpay_publisheremail` varchar(255) NOT NULL default '',
  `plugnpay_publishername` varchar(255) NOT NULL default '',
  `plugnpay_cardallowed` varchar(255) NOT NULL default '',
  `offline_email` text NOT NULL,
  `bymail_to` varchar(255) NOT NULL default '',
  `bymail_address1` varchar(255) NOT NULL default '',
  `bymail_address2` varchar(255) NOT NULL default '',
  `bymail_city` varchar(255) NOT NULL default '',
  `bymail_state` varchar(255) NOT NULL default '',
  `bymail_zip` varchar(255) NOT NULL default '',
  `status` int(1) NOT NULL default '0',
  `default_email` text NOT NULL,
  PRIMARY KEY  (`pid`)
) TYPE=MyISAM COMMENT='Table for all Payment Processors Available.' AUTO_INCREMENT=16 ;

#
# Dumping data for table `payment_process`
#

INSERT INTO `payment_process` VALUES (1, 0, 'PayPal', '', 'SSC5LA==', 'SSC5LA==', '', '', '', '', '', 0, '', '', '', '', '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', '', '', '', '', '', 0, '');
INSERT INTO `payment_process` VALUES (3, 0, 'Paysystems TPP-PRO', '', '', '', '', '', '', '', '', 0, '', '', '', '', '0', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', '', '', '', '', '', 0, '');
INSERT INTO `payment_process` VALUES (6, 0, 'Mail In Payment', '', 'SSC5LA==', 'SSC5LA==', '', '', '', '', '', 0, '', '', '', '', '0', '', '', '', '', '', '', 0, '', '', '', '', '', '', 'Your Company', 'Address', 'Address 2', 'City', 'State', 'ZipCode', 0, '');
INSERT INTO `payment_process` VALUES (4, 1, '2Checkout', '', 'SSC5LA==', 'SSC5LA==', '', '', '', '', '', 0, '', '', '', '', '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', '', '', '', '', '', 0, '');
INSERT INTO `payment_process` VALUES (2, 0, 'WorldPay Future Pay', '', 'SSC5LA==', 'SSC5LA==', '', '', '', '', '', 0, '', '', '', '', '0', '', '', '', '', '', 'USD', 0, '', '', '', '', '', '', '', '', '', '', '', '', 0, '');
INSERT INTO `payment_process` VALUES (8, 1, 'Authorize.net', 'authorize', '', '', 'USD', '', '', '', '', 0, '', '', '', '', '0', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', '', '', '', '', '', 0, '');
INSERT INTO `payment_process` VALUES (9, 0, 'Internet Secure', '', 'SSC5LA==', 'SSC5LA==', '', '', '', '', '', 0, '', '', '', '', '0', '', '', 'English', '', '', '', 0, '', '', '', '', '', '', '', '', '', '', '', '', 0, '');
INSERT INTO `payment_process` VALUES (10, 0, 'LinkPoint', '', 'SSC5LA==', 'SSC5LA==', '', '', '', '', '', 0, '', '', 'PREAUTH', '', '0', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', '', '', '', '', '', 0, '');
INSERT INTO `payment_process` VALUES (11, 0, 'PSiGate', '', 'SSC5LA==', 'SSC5LA==', '', '', '', '', '', 0, '', '', '', '', '0', '1', '', '', '', '', '', 0, '', '', '', '', '', '', '', '', '', '', '', '', 0, '');
INSERT INTO `payment_process` VALUES (12, 0, 'AlternatePalPay', '', 'SSC5LA==', 'SSC5LA==', '', '', '', '', '', 0, '', '', '', '', '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', '', '', '', '', '', 0, '');
INSERT INTO `payment_process` VALUES (13, 0, 'WorldPay[2]', '', 'SSC5LA==', 'SSC5LA==', '', '', '', '', '', 0, '', '', '', '', '0', '', '', '', '', '', 'USD', 0, '', '', '', '', '', '', '', '', '', '', '', '', 0, '');
INSERT INTO `payment_process` VALUES (14, 0, 'CyberSourceHOP', '', '', '', '', '', '', '', '', 0, '', '', '', '', '0', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', '', '', '', '', '', 0, '');
INSERT INTO `payment_process` VALUES (15, 0, 'Credit Card', '', 'SSC5LA==', 'SSC5LA==', '', '', '', '', '', 0, '', '', '', '', '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', '', '', '', '', '', 0, '');
   
# --------------------------------------------------------

#
# Table structure for table `plan_groups`
#

CREATE TABLE `plan_groups` (
  `gid` int(11) unsigned NOT NULL auto_increment,
  `name` varchar(255) NOT NULL default '',
  `group_payment` varchar(255) NOT NULL default '',
  `group_status` int(1) NOT NULL default '0',
  PRIMARY KEY  (`gid`)
) TYPE=MyISAM COMMENT='Plan Group table.' AUTO_INCREMENT=1 ;

#
# Dumping data for table `plan_groups`
#


# --------------------------------------------------------

#
# Table structure for table `plan_specs`
#

CREATE TABLE `plan_specs` (
  `pid` int(11) unsigned NOT NULL auto_increment,
  `gid` int(22) NOT NULL default '0',
  `rid` bigint(22) NOT NULL default '0',
  `addon_gid` bigint(22) NOT NULL default '0',
  `whm_id` bigint(22) NOT NULL default '0',
  `package_name` varchar(255) NOT NULL default '',
  `whm_package_name` varchar(255) NOT NULL default '',
  `plan_status` int(1) NOT NULL default '0',
  `monthly_cost` float NOT NULL default '0',
  `quarterly_cost` float NOT NULL default '0',
  `semi_annual_cost` float NOT NULL default '0',
  `annual_cost` float NOT NULL default '0',
  `monthly_pid` varchar(32) NOT NULL default '',
  `quarterly_pid` varchar(32) NOT NULL default '',
  `semi_annual_pid` varchar(32) NOT NULL default '',
  `annual_pid` varchar(32) NOT NULL default '',
  `setup_cost` float NOT NULL default '0',
  `web_space` int(10) NOT NULL default '0',
  `shell_access` int(1) NOT NULL default '0',
  `ftp` int(25) NOT NULL default '0',
  `email` int(25) NOT NULL default '0',
  `email_list` int(25) NOT NULL default '0',
  `sql` int(25) NOT NULL default '0',
  `sub_domain` int(25) NOT NULL default '0',
  `parked_domain` int(25) NOT NULL default '0',
  `addon_domain` int(25) NOT NULL default '0',
  `unique_ip_activate` int(1) NOT NULL default '0',
  `unique_ip_cost` float NOT NULL default '0',
  `cgi_access` int(1) NOT NULL default '0',
  `frontpage` int(1) NOT NULL default '0',
  `bandwidth` int(20) NOT NULL default '0',
  `cpanel_theme` varchar(255) NOT NULL default '',
  `tpp_pro_period` int(20) NOT NULL default '0',
  `com_type` int(1) NOT NULL default '0',
  `com_rate_month` float NOT NULL default '0',
  `com_rate_onetime` float NOT NULL default '0',
  `free_trial` int(1) NOT NULL default '0',
  `free_trial_length` int(2) NOT NULL default '0',
  `ip_addresses` varchar(50) NOT NULL default '',
  `memory` varchar(50) NOT NULL default '',
  `processor` varchar(50) NOT NULL default '',
  `os` varchar(50) NOT NULL default '',
  `display_text` text NOT NULL,
  `dedicated` int(1) NOT NULL default '0',
  `in_stock` int(5) NOT NULL default '0',
  `internetsecure_period` int(20) NOT NULL default '0',
  PRIMARY KEY  (`pid`)
) TYPE=MyISAM COMMENT='Plan Specifications' AUTO_INCREMENT=1 ;

#
# Dumping data for table `plan_specs`
#


# --------------------------------------------------------

#
# Table structure for table `psigate_logging`
#

CREATE TABLE `psigate_logging` (
  `logid` tinyint(22) unsigned NOT NULL auto_increment,
  `oid` varchar(22) NOT NULL default '',
  `iid` varchar(22) NOT NULL default '',
  `sid` varchar(32) NOT NULL default '',
  `raw_log` text NOT NULL,
  PRIMARY KEY  (`logid`)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

#
# Dumping data for table `psigate_logging`
#


# --------------------------------------------------------

#
# Table structure for table `reseller_profile`
#

CREATE TABLE `reseller_profile` (
  `rid` bigint(22) unsigned NOT NULL auto_increment,
  `profile_name` varchar(255) NOT NULL default '',
  `edit_ns` int(1) NOT NULL default '0',
  `limit_type` int(1) NOT NULL default '0',
  `resnumlimitamt` int(25) NOT NULL default '0',
  `rslimit_disk` int(25) NOT NULL default '0',
  `rsolimit_disk` int(25) NOT NULL default '0',
  `rslimit_bw` int(25) NOT NULL default '0',
  `rsolimit_bw` int(25) NOT NULL default '0',
  `acl_list` text NOT NULL,
  PRIMARY KEY  (`rid`)
) TYPE=MyISAM COMMENT='Reseller Profile Table' AUTO_INCREMENT=1 ;

#
# Dumping data for table `reseller_profile`
#


# --------------------------------------------------------

#
# Table structure for table `server_config`
#

CREATE TABLE `server_config` (
  `whm_id` int(22) unsigned NOT NULL auto_increment,
  `server_name` varchar(255) NOT NULL default '',
  `server_ip` varchar(25) NOT NULL default '',
  `primary_ns` varchar(255) NOT NULL default '',
  `primary_ns_ip` varchar(255) NOT NULL default '',
  `secondary_ns` varchar(255) NOT NULL default '',
  `secondary_ns_ip` varchar(255) NOT NULL default '',
  `max_accounts` int(25) NOT NULL default '0',
  `install_order` int(5) NOT NULL default '0',
  `reseller` int(1) NOT NULL default '0',
  `active_server` int(1) NOT NULL default '0',
  `manual_install_active` int(1) NOT NULL default '0',
  `server_cost` float NOT NULL default '0',
  `server_noclocal` varchar(255) NOT NULL default '0',
  `ogcreate` int(40) default NULL,
  PRIMARY KEY  (`whm_id`)
) TYPE=MyISAM AUTO_INCREMENT=2 ;

#
# Dumping data for table `server_config`
#


# --------------------------------------------------------

#
# Table structure for table `session_history`
#

CREATE TABLE `session_history` (
  `sid` varchar(32) NOT NULL default '',
  `pid` int(11) NOT NULL default '0',
  `uid` bigint(22) NOT NULL default '0',
  `whm_id` bigint(22) NOT NULL default '0',
  `payment_term` varchar(25) NOT NULL default '',
  `payment_method` int(1) NOT NULL default '0',
  `promotion_code` varchar(255) NOT NULL default '',
  `referrer_id` varchar(255) NOT NULL default '',
  `domain_name` varchar(255) NOT NULL default '',
  `tld` varchar(23) NOT NULL default '',
  `domain_registration` int(1) NOT NULL default '0',
  `domain_expire` varchar(10) NOT NULL default '',
  `addon_choices` text NOT NULL,
  `ogcreate` int(10) default NULL,
  `first_name` varchar(255) NOT NULL default '',
  `last_name` varchar(255) NOT NULL default '',
  `organization_name` varchar(255) NOT NULL default '',
  `street_address_1` varchar(255) NOT NULL default '',
  `street_address_2` varchar(255) NOT NULL default '',
  `city` varchar(255) NOT NULL default '',
  `state` varchar(255) NOT NULL default '',
  `zip_code` varchar(255) NOT NULL default '',
  `country` varchar(255) NOT NULL default '',
  `phone` varchar(255) NOT NULL default '',
  `fax` varchar(255) NOT NULL default '',
  `email` varchar(255) NOT NULL default '',
  `username` varchar(255) NOT NULL default '',
  `password` varchar(255) NOT NULL default '',
  `advert` varchar(255) NOT NULL default '',
  `advert_other` varchar(255) NOT NULL default '',
  `tos` int(1) NOT NULL default '0',
  `whm_username` varchar(7) NOT NULL default '',
  `whm_password` varchar(7) NOT NULL default '',
  `total_due_today` float NOT NULL default '0',
  `total_due_reoccur` float NOT NULL default '0',
  `client_ip` varchar(25) NOT NULL default '',
  `locked` int(11) NOT NULL default '0',
  `client_notes` text NOT NULL,
  `pns1` varchar(25) NOT NULL default 'ns1',
  `pns2` varchar(25) NOT NULL default 'ns2',
  `server_hostname` varchar(255) NOT NULL default '',
  `root_pw` varchar(255) NOT NULL default '',
  `whois` int(1) NOT NULL default '0',
  `sorp` int(1) NOT NULL default '0',
  `fraudcall_api_response` varchar(25) NOT NULL default '',
  `fraudcall_score` varchar(25) NOT NULL default '',
  `bin_number` int(6) NOT NULL default '0',
  `lpid` bigint(22) NOT NULL default '0',
  `offcid` bigint(22) NOT NULL default '0',
  `fg_call_info` longtext NOT NULL,
  KEY `sid` (`sid`),
  KEY `sid_2` (`sid`)
) TYPE=MyISAM COMMENT='Session tracking for new orders';

#
# Dumping data for table `session_history`
#


# --------------------------------------------------------

#
# Table structure for table `ticket`
#

CREATE TABLE `ticket` (
  `id` bigint(22) unsigned NOT NULL auto_increment,
  `uid` bigint(22) NOT NULL default '0',
  `email` varchar(255) NOT NULL default '',
  `subject` varchar(255) NOT NULL default '',
  `message` text NOT NULL,
  `ogcreate` int(40) default NULL,
  `status` int(11) NOT NULL default '0',
  `switch` int(1) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM COMMENT='Trouble TIcket System' AUTO_INCREMENT=1 ;

#
# Dumping data for table `ticket`
#


# --------------------------------------------------------

#
# Table structure for table `ticket_reply`
#

CREATE TABLE `ticket_reply` (
  `rid` bigint(22) unsigned NOT NULL auto_increment,
  `id` bigint(20) NOT NULL default '0',
  `reply_status` int(1) NOT NULL default '0',
  `reply` text NOT NULL,
  `ogcreate` int(40) default NULL,
  PRIMARY KEY  (`rid`)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

#
# Dumping data for table `ticket_reply`
#


# --------------------------------------------------------

#
# Table structure for table `tld_chart`
#

CREATE TABLE `tld_chart` (
  `tld_id` bigint(22) unsigned NOT NULL auto_increment,
  `tld` varchar(8) NOT NULL default '',
  `cost` float NOT NULL default '0',
  `reg_period` int(1) NOT NULL default '1',
  `coid` varchar(32) NOT NULL default '0',
  PRIMARY KEY  (`tld_id`)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

#
# Dumping data for table `tld_chart`
#


# --------------------------------------------------------

#
# Table structure for table `user`
#

CREATE TABLE `user` (
  `uid` bigint(22) unsigned NOT NULL auto_increment,
  `sid` text NOT NULL,
  `rsid` varchar(32) NOT NULL default '',
  `status` int(2) NOT NULL default '0',
  `reseller` int(1) NOT NULL default '0',
  `reseller_primary_domain` bigint(22) NOT NULL default '0',
  `reseller_profile` bigint(22) NOT NULL default '0',
  `first_name` varchar(255) NOT NULL default '',
  `last_name` varchar(255) NOT NULL default '',
  `organization_name` varchar(255) NOT NULL default '',
  `street_address_1` varchar(255) NOT NULL default '',
  `street_address_2` varchar(255) NOT NULL default '',
  `city` varchar(255) NOT NULL default '',
  `state` varchar(100) NOT NULL default '',
  `zip_code` varchar(25) NOT NULL default '',
  `country` varchar(255) NOT NULL default '',
  `phone` varchar(35) NOT NULL default '',
  `fax` varchar(35) NOT NULL default '',
  `email` varchar(255) NOT NULL default '',
  `username` varchar(255) NOT NULL default '',
  `password` text NOT NULL,
  `advert` varchar(255) NOT NULL default '',
  `advert_other` varchar(255) NOT NULL default '',
  `tos` int(1) NOT NULL default '0',
  `temp_pw` varchar(10) NOT NULL default '',
  `ogcreate` int(40) default NULL,
  `logged` int(1) NOT NULL default '0',
  PRIMARY KEY  (`uid`)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

#
# Dumping data for table `user`
#

CREATE TABLE `autopilot_news` (
`date` VARCHAR( 255 ) NOT NULL ,
`news` TEXT NOT NULL ,
INDEX ( `date` )
) TYPE = MYISAM ;