<?PHP
$installed_host = 'whmautopilotlicensing.com';
if (stristr($config['license'], 'hostgator')) {
    $installed_host = 'hostgator.whmautopilot.com';
}

$installed_directory = '/m';
if (stristr($config['license'], 'hostgator')) {
    $installed_directory = '';
}

# You can ignore everything below this line if you want to --------------------------

$query_string="license=".$license; // changed
# $query_string.="&product_id=2";

$per_server=false;
$per_install=false;
$per_site=true;

# functions -------------------------------------------------------------------------

function get_key()
	{
	$data=@file("key.php");

	if (!$data) { return false; }

	$buffer=false;
	foreach ($data as $line) { $buffer.=$line; }
	if (!$buffer) { return false; }

	$buffer=str_replace("<?PHP", "", $buffer);
	$buffer=str_replace("?>", "", $buffer);
	$buffer=str_replace("/*--", "", $buffer);
	$buffer=str_replace("--*/", "", $buffer);

	return str_replace("\n", "", $buffer);
	}

function parse_local_key()
	{
	if (!@file_exists("key.php")) { return false; }

	$raw_data=base64_decode(get_key());
	$raw_array=explode("|", $raw_data);
	if (is_array($raw_array)&&count($raw_array)<8) { return false; }

	return $raw_array;
	}

function validate_local_key($array)
	{
	$raw_array=parse_local_key();

	if (!is_array($raw_array)||$raw_array===false)
		{
		return "<verify status='invalid_key' message='Please contact support for a new license key.' />";
		}
	
	if (strcmp($raw_array[0], "aacd35f998b9948418af05cc508e8e35")!=0)
		{
		return "<verify status='invalid_key' message='Please contact support for a new license key.' />";
		}
	
	if ($raw_array[9]&&strcmp(md5("aacd35f998b9948418af05cc508e8e35".$raw_array[9]), $raw_array[10])!=0) 
		{
		return "<verify status='invalid_key' message='Please contact support for a new license key.' />";
		}
	
	if (strcmp(md5("aacd35f998b9948418af05cc508e8e35".$raw_array[1]), $raw_array[2])!=0) 
		{
		return "<verify status='invalid_key' message='Please contact support for a new license key.' ".$raw_array[9]." />";
		}

	if ($raw_array[1]<time()&&$raw_array[1]!="never") 
		{
		return "<verify status='invalid_key' message='Please contact support for a new license key.' ".$raw_array[9]." />";
		}
	
	if ($array['per_server'])
		{
		$server=phpaudit_get_mac_address();
		$mac_array=@explode(",", $raw_array[6]);
		if (!@in_array(md5("aacd35f998b9948418af05cc508e8e35".$server[0]), $mac_array)) 
			{
			return "<verify status='invalid_key' message='Please contact support for a new license key.' ".$raw_array[9]." />";
			}

		$host_array=explode(",", $raw_array[4]);
		if (!@in_array(md5("aacd35f998b9948418af05cc508e8e35".@gethostbyaddr(@gethostbyname($server[1]))), $host_array))
			{
			return "<verify status='invalid_key' message='Please contact support for a new license key.' ".$raw_array[9]." />";
			}
		}
	else if ($array['per_install']||$array['per_site'])
		{
		if ($array['per_install'])
			{
			$directory_array=@explode(",", $raw_array[3]);
			$valid_dir=path_translated();
			$valid_dir=md5("aacd35f998b9948418af05cc508e8e35".$valid_dir);
			if (!@in_array($valid_dir, $directory_array))
				{
				return "<verify status='invalid_key' message='Please contact support for a new license key.' ".$raw_array[9]." />";
				}
			}

		$host_array=@explode(",", $raw_array[4]);
		if (!@in_array(md5("aacd35f998b9948418af05cc508e8e35".$_SERVER['HTTP_HOST']), $host_array))
			{
			return "<verify status='invalid_key' message='Please contact support for a new license key.' ".$raw_array[9]." />";
			}

		$ip_array=@explode(",", $raw_array[5]);
		if (!@in_array(md5("aacd35f998b9948418af05cc508e8e35".server_addr()), $ip_array))
			{
			return "<verify status='invalid_key' message='Please contact support for a new license key.' ".$raw_array[9]." />";
			}
		}

	return "<verify status='active' message='The license key is valid.' ".$raw_array[9]." />";
	}

function phpaudit_exec_socket($http_host, $http_dir, $http_file, $querystring)
	{
	$fp=@fsockopen($http_host, 80, $errno, $errstr, 5);
	if (!$fp) { return false; }
	else
		{
		$header="POST ".($http_dir.$http_file)." HTTP/1.0\r\n";
		$header.="Host: ".$http_host."\r\n";
		$header.="Content-type: application/x-www-form-urlencoded\r\n";
		$header.="User-Agent: PHPAudit v2 (http://www.phpaudit.com)\r\n";
		$header.="Content-length: ".@strlen($querystring)."\r\n";
		$header.="Connection: close\r\n\r\n";
		$header.=$querystring;

		$data=false;
		@stream_set_timeout($fp, 20);
		@fputs($fp, $header);
		$status=@socket_get_status($fp);
		while (!@feof($fp)&&$status) 
			{ 
			$data.=@fgets($fp, 1024);
			
			$status=@socket_get_status($fp);
			}
		@fclose ($fp);
		# echo "<textarea rows='100' cols='100'>".$data."</textarea>"; die;
		if (!$data) { return false; }
		
		$data=explode("\r\n\r\n", $data, 2);
		
		if (!$data[1]) { return false; }
		if (strpos($data[1], "verify")===false) { return false; }

		return $data[1];
		}
	}

# DOES NOT WORK FOR WINDOWS!!!!!!!
# No good way to get the mac address for win.
function phpaudit_get_mac_address()
	{
	$fp=popen("/sbin/ifconfig", "r");

	if (!$fp) { return -1; } # returns invalid, cannot open ifconfig

	$res=@fread($fp, 4096);
	@pclose($fp);

	$array=@explode("HWaddr", $res);
	if (count($array)<2) { $array=@explode("ether", $res); } # FreeBSD
	$array=@explode("\n", $array[1]);
	$buffer[]=@trim($array[0]);

	$array=@explode("inet addr:", $res);
	if (count($array)<2) { $array=@explode("inet ", $res); } # FreeBSD
	$array=@explode(" ", $array[1]);
	$buffer[]=@trim($array[0]);

	return $buffer;
	}

function path_translated()
	{
	if ($_SERVER['PATH_TRANSLATED'])
		{
		return @substr($_SERVER['PATH_TRANSLATED'], 0, @strrpos($_SERVER['PATH_TRANSLATED'], "/"));
		}

	if ($_SERVER['SCRIPT_FILENAME'])
		{
		return @substr($_SERVER['SCRIPT_FILENAME'], 0, @strrpos($_SERVER['SCRIPT_FILENAME'], "/"));
		}
	
	return @substr($_SERVER['ORIG_PATH_TRANSLATED'], 0, @strrpos($_SERVER['ORIG_PATH_TRANSLATED'], "\\"));
	}

function server_addr()
	{
	return ($_SERVER['SERVER_ADDR'])?$_SERVER['SERVER_ADDR']:$_SERVER['LOCAL_ADDR'];
	}

# END functions ---------------------------------------------------------------------

if ($per_server)
	{
	$server=phpaudit_get_mac_address();
	$query_string.="&access_host=".@gethostbyaddr(@gethostbyname($server[1]));
	$query_string.="&access_mac=".$server[0];
	}
else if ($per_install)
	{
	$query_string.="&access_directory=".path_translated();
	$query_string.="&access_ip=".server_addr();
	$query_string.="&access_host=".$_SERVER['HTTP_HOST'];
	}
else if ($per_site)
	{
	$query_string.="&access_ip=".server_addr();
	$query_string.="&access_host=".$_SERVER['HTTP_HOST'];
	}

$data=phpaudit_exec_socket($installed_host, $installed_directory, "/validate_internal.php", $query_string);
if (!$data)
	{
	$array['per_server']=$per_server;
	$array['per_install']=$per_install;
	$array['per_site']=$per_site;
	$data=validate_local_key($array);
	}

$parser=@xml_parser_create('');
@xml_parser_set_option($parser, XML_OPTION_CASE_FOLDING, 0);
@xml_parser_set_option($parser, XML_OPTION_SKIP_WHITE, 1);
@xml_parse_into_struct($parser, $data, $values, $tags);
@xml_parser_free($parser);

$returned=$values[0]['attributes'];

unset($query_string);
unset($per_server);
unset($per_install);
unset($per_site);
unset($server);
unset($data);
unset($parser);
unset($values);
unset($tags);

function check_local_key()
	{
	$raw_array=parse_local_key();

	if (!@is_array($raw_array)||$raw_array===false)
		{
		return array('status' => false, 
					'expires' => 'Unknown',
					'message' => 'No local key found for this installation. Please login to the client area to get a new key.');
		}

	$local_key_expires=($raw_array[1]=='never')?'Never':date('r', $raw_array[1]);

	if ($raw_array[9]&&@strcmp(@md5("3c01b502c0c985ddec216c610f0b4cdc".$raw_array[9]), $raw_array[10])!=0)
		{
		return array('status' => false,
					'expires' => $local_key_expires,
					'message' => 'Custom variables checksum failed for this local key.');
		}

	if (@strcmp(@md5("3c01b502c0c985ddec216c610f0b4cdc".$raw_array[1]), $raw_array[2])!=0)
		{
		return array('status' => false,
					'expires' => $local_key_expires,
					'message' => 'License expiry checksum failed for this local key.');
		}

	if ($raw_array[1]<time()&&$raw_array[1]!="never")
		{
		return array('status' => false,
					'expires' => $local_key_expires,
					'message' => 'Your local license key has expired.');
		}

	if ($array['per_server'])
		{
		$server=phpaudit_get_mac_address();
		$mac_array=@explode(",", $raw_array[6]);
		if (!@in_array(@md5("3c01b502c0c985ddec216c610f0b4cdc".$server[0]), $mac_array))
			{
			return array('status' => false,
					'expires' => $local_key_expires,
					'message' => 'Local license key failed to validate the MAC address.');
			}

		$host_array=@explode(",", $raw_array[4]);
		if (!@in_array(@md5("3c01b502c0c985ddec216c610f0b4cdc".@gethostbyaddr(@gethostbyname($server[1]))), $host_array))
			{
			return array('status' => false,
					'expires' => $local_key_expires,
					'message' => 'Local license key failed to validate the host address.');
			}
		}
	else if ($array['per_install']||$array['per_site'])
		{
		if ($array['per_install'])
			{
			$directory_array=@explode(",", $raw_array[3]);
			$valid_dir=path_translated();
			$valid_dir=@md5("3c01b502c0c985ddec216c610f0b4cdc".$valid_dir);
			if (!@in_array($valid_dir, $directory_array))
				{
				return array('status' => false,
					'expires' => $local_key_expires,
					'message' => 'Local license key failed to validate the installation path.');
				}
			}

		$host_array=@explode(",", $raw_array[4]);
		if (!@in_array(@md5("3c01b502c0c985ddec216c610f0b4cdc".$_SERVER['HTTP_HOST']), $host_array))
			{
			return array('status' => false,
					'expires' => $local_key_expires,
					'message' => 'Local license key failed to validate the host address.');
			}

		$ip_array=@explode(",", $raw_array[5]);
		if (!@in_array(@md5("3c01b502c0c985ddec216c610f0b4cdc".server_addr()), $ip_array))
			{
			return array('status' => false,
					'expires' => $local_key_expires,
					'message' => 'Local license key failed to validate the IP address.');
			}
		}

	return array('status' => true,
				'expires' => $local_key_expires,
				'message' => 'Local license key is valid.');
	}

$check=check_local_key();
?>

<table width='230' cellpadding='2' cellspacing='0' border='0'>
	<tr>
		<td align='left' valign='top' class='admin_index_news_border'>
		<table width='100%' cellpadding='2' cellspacing='0' border='0'>
			<tr>
				<td><span class='text'>Local Key Status:</span> <?PHP echo ($check['status'])?'<span class=text_green>Valid':'<span class=text_red>Invalid'; ?></span></td>
			</tr>
			<tr>
				<td><span class='text'>Local Key Expires: <?PHP echo $check['expires']; ?></span></td>
			</tr>

			<?PHP if (!$check['status']): ?>
				<tr>
					<td colspan='2'><span class='text_red'><?PHP echo $check['message']; ?></span></td>
				</tr>
			<?PHP endif; ?>

		</table>
		</td>
	</tr>
</table><br />


<?PHP if ($returned['expires']): 
$expires='Never';
if ($returned['expires']!='never') { $expires=date('r', $returned['expires']); }
?>
<table width='230' cellpadding='2' cellspacing='0' border='0'>
	<tr>
		<td align='left' valign='top' class='admin_index_news_border'>
		<table width='100%' cellpadding='2' cellspacing='0' border='0'>
			<tr>
				<td><span class='text'>Remote License Status:</span> <?PHP echo ($returned['status']=='active')?'<span class=text_green>Valid':'<span class=text_red>Invalid'; ?></span></td>
			</tr>
			<tr>
				<td><span class='text'>Expires: <?PHP echo $expires; ?></span></td>
			</tr>
		</table>
		</td>
	</tr>
</table><br />
<?PHP endif; ?>