CREATE TABLE authnet_batch (
  bid bigint(22) unsigned NOT NULL auto_increment,
  customer_ip_address varchar(25) NOT NULL default '',
  description varchar(255) NOT NULL default '',
  currency_code varchar(10) NOT NULL default '',
  transaction_type varchar(25) NOT NULL default '',
  recurring_billing char(3) NOT NULL default 'YES',
  payment_method char(2) NOT NULL default 'CC',
  customer_first_name varchar(255) NOT NULL default '',
  customer_last_name varchar(255) NOT NULL default '',
  customer_address varchar(255) NOT NULL default '',
  customer_city varchar(255) NOT NULL default '',
  customer_state varchar(255) NOT NULL default '',
  customer_zip varchar(255) NOT NULL default '',
  customer_country varchar(255) NOT NULL default '',
  customer_phone varchar(25) NOT NULL default '',
  customer_fax varchar(25) NOT NULL default '',
  customer_email varchar(255) NOT NULL default '',
  card_info text NOT NULL,
  ogcreate varchar(40) NOT NULL default '',
  response_reason_text varchar(255) NOT NULL default '',
  batch_status int(1) NOT NULL default '0',
  oid bigint(22) NOT NULL default '0',
  uid bigint(22) NOT NULL default '0',
  master_batch int(1) NOT NULL default '0',
  PRIMARY KEY  (bid)
) TYPE=MyISAM COMMENT='Authorize.net Batch Creation';


DROP TABLE IF EXISTS addon_groups;
CREATE TABLE addon_groups (
  addon_gid int(11) unsigned NOT NULL auto_increment,
  name varchar(255) NOT NULL default '',
  group_payment text NOT NULL,
  group_addons text NOT NULL,
  group_status int(1) NOT NULL default '0',
  PRIMARY KEY  (addon_gid)
) TYPE=MyISAM COMMENT='Addon Group table.';

#
# Dumping data for table `addon_groups`
#

INSERT INTO addon_groups (addon_gid, name, group_payment, group_addons, group_status) VALUES (19, 'Standard Addon Group Example', '1|3|6|4|2|', '44|42|43|', 1);
# --------------------------------------------------------

#
# Table structure for table `addon_specs`
#

DROP TABLE IF EXISTS addon_specs;
CREATE TABLE addon_specs (
  aid bigint(22) unsigned NOT NULL auto_increment,
  addon_pay_methods text NOT NULL,
  addon_name varchar(255) NOT NULL default '',
  addon_description text NOT NULL,
  addon_show_description int(1) NOT NULL default '0',
  setup_cost float NOT NULL default '0',
  setup_activate int(1) NOT NULL default '0',
  addon_cost float NOT NULL default '0',
  addon_state varchar(255) NOT NULL default '',
  addon_activate int(1) NOT NULL default '0',
  unique_ip int(1) NOT NULL default '0',
  extra_webspace int(15) NOT NULL default '0',
  PRIMARY KEY  (aid)
) TYPE=MyISAM;

#
# Dumping data for table `addon_specs`
#

INSERT INTO addon_specs (aid, addon_pay_methods, addon_name, addon_description, addon_show_description, setup_cost, setup_activate, addon_cost, addon_state, addon_activate, unique_ip, extra_webspace) VALUES (44, '', 'Extra WebSpace Example', '', 0, '0', 0, '10', '2', 1, 0, 5);
INSERT INTO addon_specs (aid, addon_pay_methods, addon_name, addon_description, addon_show_description, setup_cost, setup_activate, addon_cost, addon_state, addon_activate, unique_ip, extra_webspace) VALUES (42, '', 'Private Nameservers Example', '', 0, '0', 0, '10', '2', 1, 0, 0);
INSERT INTO addon_specs (aid, addon_pay_methods, addon_name, addon_description, addon_show_description, setup_cost, setup_activate, addon_cost, addon_state, addon_activate, unique_ip, extra_webspace) VALUES (43, '', 'Unique IP Address Example', '', 0, '0', 0, '10', '2', 1, 1, 0);



ALTER TABLE `plan_specs` ADD `addon_gid` BIGINT( 22 ) NOT NULL AFTER `gid` ;
ALTER TABLE `session_history` ADD `addon_choices` TEXT NOT NULL AFTER `domain_expire` ;
ALTER TABLE `hosting_order` ADD `addon_choices` TEXT NOT NULL AFTER `payment_term` ;
ALTER TABLE `hosting_order` ADD `next_due_date` TEXT NOT NULL AFTER `uid` ;

ALTER TABLE `payment_process` ADD `x_gateway` VARCHAR( 255 ) NOT NULL AFTER `name` ,
ADD `x_Login` VARCHAR( 255 ) NOT NULL AFTER `x_gateway` ,
ADD `x_Password` VARCHAR( 255 ) NOT NULL AFTER `x_Login` ,
ADD `x_Currency_Code` VARCHAR( 5 ) NOT NULL AFTER `x_Password`,
ADD `x_fields` TEXT NOT NULL AFTER `x_Currency_Code` ;

INSERT INTO `payment_process` ( `pid` , `demo` , `name` , `x_gateway` , `x_Login` , `x_Password` , `x_Currency_Code` , `paypal_address` , `paypal_image_url` , `checkout_sid` , `paysystems_companyid` , `worldpay_id` , `worldpay_cc` , `worldpay_demo` , `worldpay_callback` , `plugnpay_subject` , `plugnpay_publisheremail` , `plugnpay_publishername` , `plugnpay_cardallowed` , `bymail_to` , `bymail_address1` , `bymail_address2` , `bymail_city` , `bymail_state` , `bymail_zip` , `status` , `default_email` ) VALUES (8, '0', 'Authorize.net', '', '', '', '', '', '', '', '', '', '', '0', '', '', '', '', '', '', '', '', '', '', '', '0', '');

update email_templates set name='Hosting Account Installed - Client Email', subject='{{domain_name}} has been installed on our servers', message='Your new site, on our servers, is now fully operational and awaits publication of your code!\r\n \r\n------------------------------------------------------\r\nYOUR NEW HOSTING ACCOUNT INFORMATION\r\n------------------------------------------------------\r\n\r\nDomain: {{domain_name}}\r\n\r\nTemporary Web Path: http://{{temporary_path}}\r\n(until your domain name resolves, use this link to access your site)\r\n\r\nIP: {{ip}}\r\n\r\nUsername: {{whm_username}}\r\n\r\nPassword: {{whm_password}} (please note password is CaSe SeNsItIvE)\r\n\r\nSMTP/POP3 mail server: mail.{{domain_name}}\r\n* email will not work until your domain resolved to our servers.\r\n\r\n------------------------------------------------------\r\n               IMPORTANT INFORMATION\r\n------------------------------------------------------\r\n\r\nCPanel Login:\r\nUsing CPanel, you can completely administer your new web hosting account! Login and check it out.\r\n\r\nhttp://{{ip}}/cpanel\r\n\r\nUsername: {{whm_username}}\r\nPassword: {{whm_password}} (please note password is CaSe SeNsItIvE)\r\n\r\nIf this account will use a transferred domain name, please update the DNS at your registrar to use the following servers:\r\n\r\n{{primary_ns}} {{primary_ns_ip}}\r\n{{secondary_ns}} {{secondary_ns_ip}}\r\n\r\nThank you for your order!\r\n\r\nWeb Support Team\r\n\r\nThis message was generated on: {{generate_date}}', attr_avail='{{ip}}|{{whm_username}}|{{whm_password}}|{{domain_name}}|{{primary_ns}}|{{primary_ns_ip}}|{{secondary_ns}}|{{secondary_ns_ip}}|{{generate_date}}|{{temporary_path}}' where emid='10';

ALTER TABLE `hosting_order` ADD `cont_resolve` INT( 1 ) DEFAULT '1' NOT NULL ;

ALTER TABLE `session_history` ADD `client_notes` TEXT NOT NULL ;
ALTER TABLE `hosting_order` ADD `client_notes` TEXT NOT NULL ;
ALTER TABLE `hosting_order` ADD `admin_notes` TEXT NOT NULL ;


INSERT INTO `email_templates` ( `emid` , `name` , `subject` , `message` , `attr_avail` ) VALUES ('33', 'Resend Password: Client Side', 'Account Login Information', 'Greetings, Someone, possibly you, requested account login information for this email address which is associated with a user account at {{site_name}}. Below is your account information: Username: {{username}} Password: {{password}} Network Operations Team {{site_name}}\n\nThis message was generated on: {{generate_date}}', '{{generate_date}}|{{site_name}}|{{username}}|{{password}}|');